/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.QueryStringProcessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class ReactiveRepositoryStringQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private final String query;

    public ReactiveRepositoryStringQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, ValueExpressionDelegate valueExpressionDelegate) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations, valueExpressionDelegate);
    }

    public ReactiveRepositoryStringQuery(String query, ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, ValueExpressionDelegate valueExpressionDelegate) {
        super(queryMethod, operations, valueExpressionDelegate.createValueContextProvider((Parameters)queryMethod.getParameters()));
        Assert.notNull((Object)query, (String)"query must not be null");
        this.query = query;
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParametersParameterAccessor parameterAccessor) {
        ConversionService conversionService = this.getElasticsearchOperations().getElasticsearchConverter().getConversionService();
        String processed = new QueryStringProcessor(this.query, this.queryMethod, conversionService, this.evaluationContextProvider).createQuery(parameterAccessor);
        return new StringQuery(processed);
    }

    @Override
    boolean isCountQuery() {
        return this.queryMethod.hasCountQueryAnnotation();
    }

    @Override
    boolean isDeleteQuery() {
        return false;
    }

    @Override
    boolean isExistsQuery() {
        return false;
    }

    @Override
    boolean isLimiting() {
        return false;
    }
}

