/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.join;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.annotation.PersistenceCreator;

public class JoinField<ID> {
    private final String name;
    private @Nullable ID parent;

    public JoinField() {
        this("default", null);
    }

    public JoinField(String name) {
        this(name, null);
    }

    @PersistenceCreator
    public JoinField(String name, @Nullable ID parent) {
        this.name = name;
        this.parent = parent;
    }

    public void setParent(@Nullable ID parent) {
        this.parent = parent;
    }

    public @Nullable ID getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JoinField)) {
            return false;
        }
        JoinField other = (JoinField)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent);
    }
}

