/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.script;

import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public record Script(String id, String language, String source) {
    public Script {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)language, (String)"language must not be null");
        Assert.notNull((Object)source, (String)"source must not be null");
    }

    public static ScriptBuilder builder() {
        return new ScriptBuilder();
    }

    public static final class ScriptBuilder {
        private @Nullable String id;
        private @Nullable String language;
        private @Nullable String source;

        private ScriptBuilder() {
        }

        public ScriptBuilder withId(String id) {
            Assert.notNull((Object)id, (String)"id must not be null");
            this.id = id;
            return this;
        }

        public ScriptBuilder withLanguage(String language) {
            Assert.notNull((Object)language, (String)"language must not be null");
            this.language = language;
            return this;
        }

        public ScriptBuilder withSource(String source) {
            Assert.notNull((Object)source, (String)"source must not be null");
            this.source = source;
            return this;
        }

        public Script build() {
            return new Script(this.id, this.language, this.source);
        }
    }
}

