/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc.rest_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.TransportUtils;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.util.Assert;

@Deprecated(since="6.0", forRemoval=true)
public final class RestClients {
    public static RestClient getRestClient(ClientConfiguration clientConfiguration) {
        return RestClients.getRestClientBuilder(clientConfiguration).build();
    }

    private static RestClientBuilder getRestClientBuilder(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        HttpHost[] httpHosts = RestClients.getHttpHosts(clientConfiguration);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(RestClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            if (clientConfiguration.getCaFingerprint().isPresent()) {
                clientBuilder.setSSLContext(TransportUtils.sslContextFromCaFingerprint((String)clientConfiguration.getCaFingerprint().get()));
            }
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(HttpHost::create).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof ElasticsearchHttpClientConfigurationCallback)) continue;
                ElasticsearchHttpClientConfigurationCallback restClientConfigurationCallback = (ElasticsearchHttpClientConfigurationCallback)clientConfigurer;
                clientBuilder = restClientConfigurationCallback.configure(clientBuilder);
            }
            return clientBuilder;
        });
        for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurationCallback : clientConfiguration.getClientConfigurers()) {
            if (!(clientConfigurationCallback instanceof ElasticsearchRestClientConfigurationCallback)) continue;
            ElasticsearchRestClientConfigurationCallback configurationCallback = (ElasticsearchRestClientConfigurationCallback)clientConfigurationCallback;
            builder = configurationCallback.configure(builder);
        }
        return builder;
    }

    private static HttpHost @NonNull [] getHttpHosts(ClientConfiguration clientConfiguration) {
        List<InetSocketAddress> hosts = clientConfiguration.getEndpoints();
        boolean useSsl = clientConfiguration.useSsl();
        return (HttpHost[])hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).map(HttpHost::create).toArray(HttpHost[]::new);
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    public static RestClientOptions.Builder getRestClientOptionsBuilder(@Nullable TransportOptions transportOptions) {
        if (transportOptions instanceof RestClientOptions) {
            RestClientOptions restClientOptions = (RestClientOptions)transportOptions;
            return restClientOptions.toBuilder();
        }
        RestClientOptions.Builder builder = new RestClientOptions.Builder(RequestOptions.DEFAULT.toBuilder());
        if (transportOptions != null) {
            transportOptions.headers().forEach(header -> builder.addHeader((String)header.getKey(), (String)header.getValue()));
            transportOptions.queryParameters().forEach((arg_0, arg_1) -> ((RestClientOptions.Builder)builder).setParameter(arg_0, arg_1));
            builder.onWarnings(transportOptions.onWarnings());
        }
        return builder;
    }

    public static interface ElasticsearchRestClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<RestClientBuilder> {
        public static ElasticsearchRestClientConfigurationCallback from(Function<RestClientBuilder, RestClientBuilder> restClientBuilderCallback) {
            Assert.notNull(restClientBuilderCallback, (String)"restClientBuilderCallback must not be null");
            return restClientBuilderCallback::apply;
        }
    }

    record CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) implements HttpRequestInterceptor
    {
        public void process(HttpRequest request, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Arrays.stream(RestClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    public static interface ElasticsearchHttpClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static ElasticsearchHttpClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> httpClientBuilderCallback) {
            Assert.notNull(httpClientBuilderCallback, (String)"httpClientBuilderCallback must not be null");
            return httpClientBuilderCallback::apply;
        }
    }
}

