/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest5_client.low_level.RequestOptions;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.util.function.Consumer;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.elasticsearch.client.RestClient;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.AutoCloseableElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.rest5_client.Rest5Clients;
import org.springframework.data.elasticsearch.client.elc.rest_client.RestClients;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.util.Assert;

public final class ElasticsearchClients {
    private static final String X_SPRING_DATA_ELASTICSEARCH_CLIENT = "X-SpringDataElasticsearch-Client";
    public static final String IMPERATIVE_CLIENT = "imperative";
    public static final String REACTIVE_CLIENT = "reactive";
    private static final JsonpMapper DEFAULT_JSONP_MAPPER = new JacksonJsonpMapper();

    public static ReactiveElasticsearchClient createReactive(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return ElasticsearchClients.createReactive(RestClients.getRestClient(clientConfiguration), null, DEFAULT_JSONP_MAPPER);
    }

    public static ReactiveElasticsearchClient createReactive(ClientConfiguration clientConfiguration, @Nullable TransportOptions transportOptions) {
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        return ElasticsearchClients.createReactive(RestClients.getRestClient(clientConfiguration), transportOptions, DEFAULT_JSONP_MAPPER);
    }

    public static ReactiveElasticsearchClient createReactive(ClientConfiguration clientConfiguration, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return ElasticsearchClients.createReactive(RestClients.getRestClient(clientConfiguration), transportOptions, jsonpMapper);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static ReactiveElasticsearchClient createReactive(RestClient restClient) {
        return ElasticsearchClients.createReactive(restClient, null, DEFAULT_JSONP_MAPPER);
    }

    public static ReactiveElasticsearchClient createReactive(Rest5Client rest5Client) {
        return ElasticsearchClients.createReactive(rest5Client, null, DEFAULT_JSONP_MAPPER);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static ReactiveElasticsearchClient createReactive(RestClient restClient, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        ElasticsearchTransport transport = ElasticsearchClients.getElasticsearchTransport(restClient, REACTIVE_CLIENT, transportOptions, jsonpMapper);
        return ElasticsearchClients.createReactive(transport);
    }

    public static ReactiveElasticsearchClient createReactive(Rest5Client rest5Client, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)rest5Client, (String)"restClient must not be null");
        ElasticsearchTransport transport = ElasticsearchClients.getElasticsearchTransport(rest5Client, REACTIVE_CLIENT, transportOptions, jsonpMapper);
        return ElasticsearchClients.createReactive(transport);
    }

    public static ReactiveElasticsearchClient createReactive(ElasticsearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return new ReactiveElasticsearchClient(transport);
    }

    public static ElasticsearchClient createImperative(ClientConfiguration clientConfiguration) {
        return ElasticsearchClients.createImperative(Rest5Clients.getRest5Client(clientConfiguration), null, DEFAULT_JSONP_MAPPER);
    }

    public static ElasticsearchClient createImperative(ClientConfiguration clientConfiguration, TransportOptions transportOptions) {
        return ElasticsearchClients.createImperative(Rest5Clients.getRest5Client(clientConfiguration), transportOptions, DEFAULT_JSONP_MAPPER);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static ElasticsearchClient createImperative(RestClient restClient) {
        return ElasticsearchClients.createImperative(restClient, null, DEFAULT_JSONP_MAPPER);
    }

    public static ElasticsearchClient createImperative(Rest5Client rest5Client) {
        return ElasticsearchClients.createImperative(rest5Client, null, DEFAULT_JSONP_MAPPER);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static ElasticsearchClient createImperative(RestClient restClient, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        ElasticsearchTransport transport = ElasticsearchClients.getElasticsearchTransport(restClient, IMPERATIVE_CLIENT, transportOptions, jsonpMapper);
        return ElasticsearchClients.createImperative(transport);
    }

    public static ElasticsearchClient createImperative(Rest5Client rest5Client, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)rest5Client, (String)"restClient must not be null");
        ElasticsearchTransport transport = ElasticsearchClients.getElasticsearchTransport(rest5Client, IMPERATIVE_CLIENT, transportOptions, jsonpMapper);
        return ElasticsearchClients.createImperative(transport);
    }

    public static AutoCloseableElasticsearchClient createImperative(ElasticsearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return new AutoCloseableElasticsearchClient(transport);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static ElasticsearchTransport getElasticsearchTransport(RestClient restClient, String clientType, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)clientType, (String)"clientType must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        TransportOptions.Builder transportOptionsBuilder = transportOptions != null ? transportOptions.toBuilder() : new RestClientOptions(org.elasticsearch.client.RequestOptions.DEFAULT, false).toBuilder();
        RestClientOptions.Builder restClientOptionsBuilder = RestClients.getRestClientOptionsBuilder(transportOptions);
        ContentType jsonContentType = Version.VERSION == null ? ContentType.APPLICATION_JSON : ContentType.create((String)"application/vnd.elasticsearch+json", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("compatible-with", String.valueOf(Version.VERSION.major()))});
        Consumer<String> setHeaderIfNotPresent = header -> {
            if (restClientOptionsBuilder.build().headers().stream().noneMatch(h -> ((String)h.getKey()).equalsIgnoreCase((String)header))) {
                restClientOptionsBuilder.addHeader(header, jsonContentType.toString());
            }
        };
        setHeaderIfNotPresent.accept("Content-Type");
        setHeaderIfNotPresent.accept("Accept");
        restClientOptionsBuilder.addHeader(X_SPRING_DATA_ELASTICSEARCH_CLIENT, clientType);
        return new RestClientTransport(restClient, jsonpMapper, restClientOptionsBuilder.build());
    }

    public static ElasticsearchTransport getElasticsearchTransport(Rest5Client rest5Client, String clientType, @Nullable TransportOptions transportOptions, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)rest5Client, (String)"restClient must not be null");
        Assert.notNull((Object)clientType, (String)"clientType must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        TransportOptions.Builder transportOptionsBuilder = transportOptions != null ? transportOptions.toBuilder() : new Rest5ClientOptions(RequestOptions.DEFAULT, false).toBuilder();
        Rest5ClientOptions.Builder rest5ClientOptionsBuilder = Rest5Clients.getRest5ClientOptionsBuilder(transportOptions);
        rest5ClientOptionsBuilder.addHeader(X_SPRING_DATA_ELASTICSEARCH_CLIENT, VersionInfo.clientVersions() + " / " + clientType);
        return new Rest5ClientTransport(rest5Client, jsonpMapper, rest5ClientOptionsBuilder.build());
    }
}

