/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.ActiveShardCount;
import org.springframework.data.elasticsearch.core.RefreshPolicy;

public class BulkOptions {
    private static final BulkOptions defaultOptions = BulkOptions.builder().build();
    private final @Nullable Duration timeout;
    private final @Nullable RefreshPolicy refreshPolicy;
    private final @Nullable ActiveShardCount waitForActiveShards;
    private final @Nullable String pipeline;
    private final @Nullable String routingId;

    private BulkOptions(@Nullable Duration timeout, @Nullable RefreshPolicy refreshPolicy, @Nullable ActiveShardCount waitForActiveShards, @Nullable String pipeline, @Nullable String routingId) {
        this.timeout = timeout;
        this.refreshPolicy = refreshPolicy;
        this.waitForActiveShards = waitForActiveShards;
        this.pipeline = pipeline;
        this.routingId = routingId;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public @Nullable RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public @Nullable ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public @Nullable String getPipeline() {
        return this.pipeline;
    }

    public @Nullable String getRoutingId() {
        return this.routingId;
    }

    public static BulkOptionsBuilder builder() {
        return new BulkOptionsBuilder();
    }

    public static BulkOptions defaultOptions() {
        return defaultOptions;
    }

    public static class BulkOptionsBuilder {
        private @Nullable Duration timeout;
        private @Nullable RefreshPolicy refreshPolicy;
        private @Nullable ActiveShardCount waitForActiveShards;
        private @Nullable String pipeline;
        private @Nullable String routingId;

        private BulkOptionsBuilder() {
        }

        public BulkOptionsBuilder withTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public BulkOptionsBuilder withRefreshPolicy(RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public BulkOptionsBuilder withWaitForActiveShards(ActiveShardCount waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        public BulkOptionsBuilder withPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public BulkOptionsBuilder withRoutingId(String routingId) {
            this.routingId = routingId;
            return this;
        }

        public BulkOptions build() {
            return new BulkOptions(this.timeout, this.refreshPolicy, this.waitForActiveShards, this.pipeline, this.routingId);
        }
    }
}

