/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface IndexOperationsAdapter
extends IndexOperations {
    public static IndexOperationsAdapter blocking(final ReactiveIndexOperations reactiveIndexOperations) {
        Assert.notNull((Object)reactiveIndexOperations, (String)"reactiveIndexOperations must not be null");
        return new IndexOperationsAdapter(){

            @Override
            public boolean create() {
                return Boolean.TRUE.equals(reactiveIndexOperations.create().block());
            }

            @Override
            public boolean create(Map<String, Object> settings) {
                return Boolean.TRUE.equals(reactiveIndexOperations.create(settings).block());
            }

            @Override
            public boolean create(Map<String, Object> settings, Document mapping) {
                return Boolean.TRUE.equals(reactiveIndexOperations.create(settings, mapping).block());
            }

            @Override
            public boolean createWithMapping() {
                return Boolean.TRUE.equals(reactiveIndexOperations.createWithMapping().block());
            }

            @Override
            public boolean delete() {
                return Boolean.TRUE.equals(reactiveIndexOperations.delete().block());
            }

            @Override
            public boolean exists() {
                return Boolean.TRUE.equals(reactiveIndexOperations.exists().block());
            }

            @Override
            public void refresh() {
                reactiveIndexOperations.refresh().block();
            }

            @Override
            public Document createMapping() {
                return Objects.requireNonNull((Document)reactiveIndexOperations.createMapping().block());
            }

            @Override
            public Document createMapping(Class<?> clazz) {
                return Objects.requireNonNull((Document)reactiveIndexOperations.createMapping(clazz).block());
            }

            @Override
            public boolean putMapping(Document mapping) {
                return Boolean.TRUE.equals(reactiveIndexOperations.putMapping((Mono<Document>)Mono.just((Object)mapping)).block());
            }

            @Override
            public Map<String, Object> getMapping() {
                return Objects.requireNonNull((Document)reactiveIndexOperations.getMapping().block());
            }

            @Override
            public Settings createSettings() {
                return Objects.requireNonNull((Settings)reactiveIndexOperations.createSettings().block());
            }

            @Override
            public Settings createSettings(Class<?> clazz) {
                return Objects.requireNonNull((Settings)reactiveIndexOperations.createSettings(clazz).block());
            }

            @Override
            public Settings getSettings() {
                return Objects.requireNonNull((Settings)reactiveIndexOperations.getSettings().block());
            }

            @Override
            public Settings getSettings(boolean includeDefaults) {
                return Objects.requireNonNull((Settings)reactiveIndexOperations.getSettings(includeDefaults).block());
            }

            @Override
            public boolean alias(AliasActions aliasActions) {
                return Boolean.TRUE.equals(reactiveIndexOperations.alias(aliasActions).block());
            }

            @Override
            public Map<String, Set<AliasData>> getAliases(String ... aliasNames) {
                return Objects.requireNonNull((Map)reactiveIndexOperations.getAliases(aliasNames).block());
            }

            @Override
            public Map<String, Set<AliasData>> getAliasesForIndex(String ... indexNames) {
                return Objects.requireNonNull((Map)reactiveIndexOperations.getAliasesForIndex(indexNames).block());
            }

            @Override
            @Deprecated
            public boolean putTemplate(PutTemplateRequest putTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.putTemplate(putTemplateRequest).block());
            }

            @Override
            public boolean putIndexTemplate(PutIndexTemplateRequest putIndexTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.putIndexTemplate(putIndexTemplateRequest).block());
            }

            @Override
            public boolean putComponentTemplate(PutComponentTemplateRequest putComponentTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.putComponentTemplate(putComponentTemplateRequest).block());
            }

            @Override
            public boolean existsComponentTemplate(ExistsComponentTemplateRequest existsComponentTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.existsComponentTemplate(existsComponentTemplateRequest).block());
            }

            @Override
            public List<TemplateResponse> getComponentTemplate(GetComponentTemplateRequest getComponentTemplateRequest) {
                return Objects.requireNonNull((List)reactiveIndexOperations.getComponentTemplate(getComponentTemplateRequest).collectList().block());
            }

            @Override
            public boolean deleteComponentTemplate(DeleteComponentTemplateRequest deleteComponentTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.deleteComponentTemplate(deleteComponentTemplateRequest).block());
            }

            @Override
            @Deprecated
            public @Nullable TemplateData getTemplate(GetTemplateRequest getTemplateRequest) {
                return (TemplateData)Objects.requireNonNull(reactiveIndexOperations).getTemplate(getTemplateRequest).block();
            }

            @Override
            @Deprecated
            public boolean existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.existsTemplate(existsTemplateRequest).block());
            }

            @Override
            public boolean existsIndexTemplate(ExistsIndexTemplateRequest existsTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.existsIndexTemplate(existsTemplateRequest).block());
            }

            @Override
            public List<TemplateResponse> getIndexTemplate(GetIndexTemplateRequest getIndexTemplateRequest) {
                return Objects.requireNonNull((List)reactiveIndexOperations.getIndexTemplate(getIndexTemplateRequest).collectList().block());
            }

            @Override
            public boolean deleteIndexTemplate(DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.deleteIndexTemplate(deleteIndexTemplateRequest).block());
            }

            @Override
            @Deprecated
            public boolean deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
                return Boolean.TRUE.equals(reactiveIndexOperations.deleteTemplate(deleteTemplateRequest).block());
            }

            @Override
            public List<IndexInformation> getInformation(IndexCoordinates index) {
                return Objects.requireNonNull((List)reactiveIndexOperations.getInformation(index).collectList().block());
            }

            @Override
            public IndexCoordinates getIndexCoordinates() {
                return reactiveIndexOperations.getIndexCoordinates();
            }
        };
    }
}

