/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc.rest5_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.TransportUtils;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.low_level.RequestOptions;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.Rest5ClientBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.BasicClientTlsStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.util.Assert;

public final class Rest5Clients {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 0;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;

    private Rest5Clients() {
    }

    public static Rest5Client getRest5Client(ClientConfiguration clientConfiguration) {
        return Rest5Clients.getRest5ClientBuilder(clientConfiguration).build();
    }

    private static Rest5ClientBuilder getRest5ClientBuilder(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        HttpHost[] httpHosts = Rest5Clients.getHttpHosts(clientConfiguration);
        Rest5ClientBuilder builder = Rest5Client.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(Rest5Clients.toHeaderArray(headers));
        }
        CloseableHttpAsyncClient httpClient = Rest5Clients.createHttpClient(clientConfiguration);
        builder.setHttpClient(httpClient);
        for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurationCallback : clientConfiguration.getClientConfigurers()) {
            if (!(clientConfigurationCallback instanceof ElasticsearchRest5ClientConfigurationCallback)) continue;
            ElasticsearchRest5ClientConfigurationCallback configurationCallback = (ElasticsearchRest5ClientConfigurationCallback)clientConfigurationCallback;
            builder = configurationCallback.configure(builder);
        }
        return builder;
    }

    private static HttpHost @NonNull [] getHttpHosts(ClientConfiguration clientConfiguration) {
        List<InetSocketAddress> hosts = clientConfiguration.getEndpoints();
        boolean useSsl = clientConfiguration.useSsl();
        return (HttpHost[])hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).map(URI::create).map(HttpHost::create).toArray(HttpHost[]::new);
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toList().toArray(new Header[0]);
    }

    private static CloseableHttpAsyncClient createHttpClient(ClientConfiguration clientConfiguration) {
        Duration socketTimeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        Duration connectTimeout = clientConfiguration.getConnectTimeout();
        if (!connectTimeout.isNegative()) {
            connectionConfigBuilder.setConnectTimeout(Timeout.of((long)Math.toIntExact(connectTimeout.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
            Timeout soTimeout = Timeout.of((long)Math.toIntExact(socketTimeout.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
            connectionConfigBuilder.setSocketTimeout(soTimeout);
            requestConfigBuilder.setConnectionRequestTimeout(soTimeout);
        } else {
            connectionConfigBuilder.setSocketTimeout(Timeout.of((long)30000L, (TimeUnit)TimeUnit.MILLISECONDS));
            requestConfigBuilder.setConnectionRequestTimeout(Timeout.of((long)0L, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        try {
            SSLContext sslContext = clientConfiguration.getCaFingerprint().isPresent() ? TransportUtils.sslContextFromCaFingerprint((String)clientConfiguration.getCaFingerprint().get()) : (clientConfiguration.getSslContext().isPresent() ? clientConfiguration.getSslContext().get() : SSLContext.getDefault());
            ConnectionConfig connectionConfig = connectionConfigBuilder.build();
            final PoolingAsyncClientConnectionManager defaultConnectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).setMaxConnPerRoute(10).setMaxConnTotal(30).setTlsStrategy((TlsStrategy)new BasicClientTlsStrategy(sslContext)).build();
            final RequestConfig requestConfig = requestConfigBuilder.build();
            var immutableRefToHttpClientBuilder = new Object(){
                HttpAsyncClientBuilder httpClientBuilder;
                {
                    this.httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((AsyncClientConnectionManager)defaultConnectionManager).setUserAgent(VersionInfo.clientVersions()).setTargetAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy()).setThreadFactory((ThreadFactory)new RestClientThreadFactory());
                }
            };
            clientConfiguration.getProxy().ifPresent(proxy -> {
                try {
                    DefaultProxyRoutePlanner proxyRoutePlanner = new DefaultProxyRoutePlanner(HttpHost.create((String)proxy));
                    immutableRefToHttpClientBuilder.httpClientBuilder.setRoutePlanner((HttpRoutePlanner)proxyRoutePlanner);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
            immutableRefToHttpClientBuilder.httpClientBuilder.addRequestInterceptorFirst((request, entity, context) -> clientConfiguration.getHeadersSupplier().get().forEach((header, values) -> {
                if ("Accept".equalsIgnoreCase((String)header) || " Content-Type".equalsIgnoreCase((String)header)) {
                    request.removeHeaders(header);
                }
                values.forEach(value -> request.addHeader(header, value));
            }));
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof ElasticsearchHttpClientConfigurationCallback)) continue;
                ElasticsearchHttpClientConfigurationCallback httpClientConfigurer = (ElasticsearchHttpClientConfigurationCallback)clientConfigurer;
                immutableRefToHttpClientBuilder.httpClientBuilder = httpClientConfigurer.configure(immutableRefToHttpClientBuilder.httpClientBuilder);
            }
            return immutableRefToHttpClientBuilder.httpClientBuilder.build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public static Rest5ClientOptions.Builder getRest5ClientOptionsBuilder(@Nullable TransportOptions transportOptions) {
        if (transportOptions instanceof Rest5ClientOptions) {
            Rest5ClientOptions rest5ClientOptions = (Rest5ClientOptions)transportOptions;
            return rest5ClientOptions.toBuilder();
        }
        Rest5ClientOptions.Builder builder = new Rest5ClientOptions.Builder(RequestOptions.DEFAULT.toBuilder());
        if (transportOptions != null) {
            transportOptions.headers().forEach(header -> builder.addHeader((String)header.getKey(), (String)header.getValue()));
            transportOptions.queryParameters().forEach((arg_0, arg_1) -> ((Rest5ClientOptions.Builder)builder).setParameter(arg_0, arg_1));
            builder.onWarnings(transportOptions.onWarnings());
        }
        return builder;
    }

    public static interface ElasticsearchRest5ClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<Rest5ClientBuilder> {
        public static ElasticsearchRest5ClientConfigurationCallback from(Function<Rest5ClientBuilder, Rest5ClientBuilder> rest5ClientBuilderCallback) {
            Assert.notNull(rest5ClientBuilderCallback, (String)"rest5ClientBuilderCallback must not be null");
            return rest5ClientBuilderCallback::apply;
        }
    }

    public static interface ElasticsearchHttpClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static ElasticsearchHttpClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> httpClientBuilderCallback) {
            Assert.notNull(httpClientBuilderCallback, (String)"httpClientBuilderCallback must not be null");
            return httpClientBuilderCallback::apply;
        }
    }

    private static class RestClientThreadFactory
    implements ThreadFactory {
        private static final AtomicLong CLIENT_THREAD_POOL_ID_GENERATOR = new AtomicLong();
        private final long clientThreadPoolId = CLIENT_THREAD_POOL_ID_GENERATOR.getAndIncrement();
        private final AtomicLong clientThreadId = new AtomicLong();

        private RestClientThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, String.format(Locale.ROOT, "elasticsearch-rest-client-%d-thread-%d", this.clientThreadPoolId, this.clientThreadId.incrementAndGet()));
        }
    }
}

