/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.index.TemplateResponseData;
import org.springframework.util.Assert;

public record TemplateResponse(String name, @Nullable Long version, @Nullable TemplateResponseData templateData) {
    public TemplateResponse(String name, @Nullable Long version, @Nullable TemplateResponseData templateData) {
        Assert.notNull((Object)name, (String)"name must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String name;
        private @Nullable Long version;
        private @Nullable TemplateResponseData templateData;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder withTemplateData(TemplateResponseData templateData) {
            this.templateData = templateData;
            return this;
        }

        public TemplateResponse build() {
            return new TemplateResponse(this.name, this.version, this.templateData);
        }
    }
}

