/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.join.JoinField;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class EntityOperations {
    private static final String ID_FIELD = "id";
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context;

    public EntityOperations(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
        Assert.notNull(context, (String)"context must not be null");
        this.context = context;
    }

    <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return MappedEntity.of(entity, this.context);
    }

    public <T> AdaptableEntity<T> forEntity(T entity, ConversionService conversionService, RoutingResolver routingResolver) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return AdaptableMappedEntity.of(entity, this.context, conversionService, routingResolver);
    }

    public <T> T updateIndexedObject(T entity, IndexedObjectInformation indexedObjectInformation, ElasticsearchConverter elasticsearchConverter, RoutingResolver routingResolver) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)indexedObjectInformation, (String)"indexedObjectInformation must not be null");
        Assert.notNull((Object)elasticsearchConverter, (String)"elasticsearchConverter must not be null");
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)elasticsearchConverter.getMappingContext().getPersistentEntity(entity.getClass());
        if (persistentEntity != null) {
            ElasticsearchPersistentProperty indexedIndexNameProperty;
            PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
            if (indexedObjectInformation.id() != null && idProperty != null && (idProperty.isReadable() || idProperty.getOwner().getType().isRecord()) && idProperty.getType().isAssignableFrom(String.class)) {
                propertyAccessor.setProperty((PersistentProperty)idProperty, (Object)indexedObjectInformation.id());
            }
            if (indexedObjectInformation.seqNo() != null && indexedObjectInformation.primaryTerm() != null && persistentEntity.hasSeqNoPrimaryTermProperty()) {
                ElasticsearchPersistentProperty seqNoPrimaryTermProperty = persistentEntity.getSeqNoPrimaryTermProperty();
                propertyAccessor.setProperty((PersistentProperty)seqNoPrimaryTermProperty, (Object)new SeqNoPrimaryTerm(indexedObjectInformation.seqNo(), indexedObjectInformation.primaryTerm()));
            }
            if (indexedObjectInformation.version() != null && persistentEntity.hasVersionProperty()) {
                ElasticsearchPersistentProperty versionProperty = persistentEntity.getVersionProperty();
                propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)indexedObjectInformation.version());
            }
            if ((indexedIndexNameProperty = persistentEntity.getIndexedIndexNameProperty()) != null) {
                propertyAccessor.setProperty((PersistentProperty)indexedIndexNameProperty, (Object)indexedObjectInformation.index());
            }
            return (T)propertyAccessor.getBean();
        }
        AdaptableEntity<T> adaptableEntity = this.forEntity(entity, elasticsearchConverter.getConversionService(), routingResolver);
        adaptableEntity.populateIdIfNecessary(indexedObjectInformation.id());
        return entity;
    }

    IndexCoordinates determineIndex(Entity<?> entity, @Nullable String index) {
        return this.determineIndex(entity.getPersistentEntity(), index);
    }

    IndexCoordinates determineIndex(ElasticsearchPersistentEntity<?> persistentEntity, @Nullable String index) {
        return index != null ? IndexCoordinates.of(index) : persistentEntity.getIndexCoordinates();
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends MapBackedEntity<T> {
        SimpleMappedEntity(T map) {
            super(map);
        }

        @Override
        public Object getId() {
            return this.getBean().get(EntityOperations.ID_FIELD);
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final ElasticsearchPersistentEntity<?> entity;
        private final IdentifierAccessor idAccessor;
        private final PersistentPropertyAccessor<T> propertyAccessor;

        private MappedEntity(ElasticsearchPersistentEntity<?> entity, IdentifierAccessor idAccessor, PersistentPropertyAccessor<T> propertyAccessor) {
            Assert.notNull(entity, (String)"entity must not ne null");
            Assert.notNull((Object)idAccessor, (String)"idAccessor must not ne null");
            Assert.notNull(propertyAccessor, (String)"propertyAccessor must not ne null");
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
        }

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor);
        }

        @Override
        public Object getId() {
            return this.idAccessor.getIdentifier();
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        public @Nullable Object getVersion() {
            return this.propertyAccessor.getProperty((PersistentProperty)this.entity.getVersionProperty());
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }

        @Override
        public ElasticsearchPersistentEntity<?> getPersistentEntity() {
            return this.entity;
        }
    }

    private static class AdaptableMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptableEntity<T> {
        private final ElasticsearchPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;
        private final ConversionService conversionService;
        private final RoutingResolver routingResolver;

        private AdaptableMappedEntity(T bean, ElasticsearchPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor, ConversionService conversionService, RoutingResolver routingResolver) {
            super(entity, identifierAccessor, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
            this.conversionService = conversionService;
            this.routingResolver = routingResolver;
        }

        static <T> AdaptableEntity<T> of(T bean, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context, ConversionService conversionService, RoutingResolver routingResolver) {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptableMappedEntity<T>(bean, entity, identifierAccessor, new ConvertingPropertyAccessor(propertyAccessor, conversionService), conversionService, routingResolver);
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public @Nullable T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return null;
            }
            Object bean = this.propertyAccessor.getBean();
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)bean;
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)bean;
            }
            this.propertyAccessor.setProperty((PersistentProperty)idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public @Nullable Number getVersion() {
            ElasticsearchPersistentProperty versionProperty = this.entity.getVersionProperty();
            return versionProperty != null ? (Number)((Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class)) : (Number)null;
        }

        @Override
        public boolean hasSeqNoPrimaryTerm() {
            return this.entity.hasSeqNoPrimaryTermProperty();
        }

        @Override
        public SeqNoPrimaryTerm getSeqNoPrimaryTerm() {
            ElasticsearchPersistentProperty seqNoPrimaryTermProperty = this.entity.getRequiredSeqNoPrimaryTermProperty();
            return (SeqNoPrimaryTerm)this.propertyAccessor.getProperty((PersistentProperty)seqNoPrimaryTermProperty, SeqNoPrimaryTerm.class);
        }

        @Override
        public T initializeVersionProperty() {
            ElasticsearchPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (ElasticsearchPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            ElasticsearchPersistentProperty versionProperty = (ElasticsearchPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public String getRouting() {
            JoinField joinField;
            String routing = this.routingResolver.getRouting(this.propertyAccessor.getBean());
            if (routing != null) {
                return routing;
            }
            ElasticsearchPersistentProperty joinFieldProperty = this.entity.getJoinFieldProperty();
            if (joinFieldProperty != null && (joinField = (JoinField)this.propertyAccessor.getProperty((PersistentProperty)joinFieldProperty, JoinField.class)) != null && joinField.getParent() != null) {
                return (String)this.conversionService.convert(joinField.getParent(), String.class);
            }
            return null;
        }
    }

    public static interface AdaptableEntity<T>
    extends Entity<T> {
        public @Nullable T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        public @Nullable Number getVersion();

        public boolean hasSeqNoPrimaryTerm();

        public @Nullable SeqNoPrimaryTerm getSeqNoPrimaryTerm();

        public @Nullable String getRouting();
    }

    static interface Entity<T> {
        public @Nullable Object getId();

        default public boolean isVersionedEntity() {
            return false;
        }

        public @Nullable Object getVersion();

        public T getBean();

        public boolean isNew();

        public @Nullable ElasticsearchPersistentEntity<?> getPersistentEntity();

        default public ElasticsearchPersistentEntity<?> getRequiredPersistentEntity() {
            ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity();
            if (persistentEntity == null) {
                throw new IllegalStateException("No ElasticsearchPersistentEntity available for this entity!");
            }
            return persistentEntity;
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    extends MapBackedEntity<T> {
        UnmappedEntity(T map) {
            super(map);
        }
    }

    private static class MapBackedEntity<T extends Map<String, Object>>
    implements AdaptableEntity<T> {
        private final T map;

        public MapBackedEntity(T map) {
            Assert.notNull(map, (String)"map must not be null");
            this.map = map;
        }

        @Override
        public Object getId() {
            return this.map.get(EntityOperations.ID_FIELD);
        }

        @Override
        public @Nullable T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)EntityOperations.ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        public @Nullable Number getVersion() {
            return null;
        }

        @Override
        public boolean hasSeqNoPrimaryTerm() {
            return false;
        }

        @Override
        public SeqNoPrimaryTerm getSeqNoPrimaryTerm() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(EntityOperations.ID_FIELD) != null;
        }

        @Override
        public ElasticsearchPersistentEntity<?> getPersistentEntity() {
            return null;
        }

        @Override
        public String getRouting() {
            return null;
        }
    }
}

