/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.elasticsearch.core.query.InnerHitsQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HasChildQuery {
    private final String type;
    private final Query query;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final Integer maxChildren;
    @Nullable
    private final Integer minChildren;
    @Nullable
    private final ScoreMode scoreMode;
    @Nullable
    private final InnerHitsQuery innerHitsQuery;

    public static Builder builder(String type) {
        return new Builder(type);
    }

    private HasChildQuery(Builder builder) {
        this.type = builder.type;
        this.query = builder.query;
        this.innerHitsQuery = builder.innerHitsQuery;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.maxChildren = builder.maxChildren;
        this.minChildren = builder.minChildren;
        this.scoreMode = builder.scoreMode;
    }

    public String getType() {
        return this.type;
    }

    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Boolean getIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public Integer getMaxChildren() {
        return this.maxChildren;
    }

    @Nullable
    public Integer getMinChildren() {
        return this.minChildren;
    }

    @Nullable
    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @Nullable
    public InnerHitsQuery getInnerHitsQuery() {
        return this.innerHitsQuery;
    }

    public static final class Builder {
        private final String type;
        private Query query;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private Integer maxChildren;
        @Nullable
        private Integer minChildren;
        @Nullable
        private ScoreMode scoreMode;
        @Nullable
        private InnerHitsQuery innerHitsQuery;

        private Builder(String type) {
            Assert.notNull((Object)type, (String)"type must not be null");
            this.type = type;
        }

        public Builder withQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder withIgnoreUnmapped(@Nullable Boolean ignoreUnmapped) {
            this.ignoreUnmapped = ignoreUnmapped;
            return this;
        }

        public Builder withMaxChildren(@Nullable Integer maxChildren) {
            this.maxChildren = maxChildren;
            return this;
        }

        public Builder withMinChildren(@Nullable Integer minChildren) {
            this.minChildren = minChildren;
            return this;
        }

        public Builder withScoreMode(@Nullable ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
            return this;
        }

        public Builder withInnerHitsQuery(@Nullable InnerHitsQuery innerHitsQuery) {
            this.innerHitsQuery = innerHitsQuery;
            return this;
        }

        public HasChildQuery build() {
            Assert.notNull((Object)this.query, (String)"query must not be null.");
            return new HasChildQuery(this);
        }
    }

    public static enum ScoreMode {
        Default,
        Avg,
        Max,
        Min,
        Sum;

    }
}

