/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.elasticsearch.core.convert.GeoConverters;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchSimpleTypes;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.NumberUtils;

public class ElasticsearchCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Converter<?, ?>> STORE_CONVERTERS;

    public ElasticsearchCustomConversions(Collection<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    static {
        ArrayList converters = new ArrayList(GeoConverters.getConvertersToRegister());
        converters.add(StringToUUIDConverter.INSTANCE);
        converters.add(UUIDToStringConverter.INSTANCE);
        converters.add(BigDecimalToDoubleConverter.INSTANCE);
        converters.add(DoubleToBigDecimalConverter.INSTANCE);
        converters.add(ByteArrayToBase64Converter.INSTANCE);
        converters.add(Base64ToByteArrayConverter.INSTANCE);
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)ElasticsearchSimpleTypes.HOLDER, STORE_CONVERTERS);
    }

    @ReadingConverter
    static enum StringToUUIDConverter implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return UUID.fromString(source);
        }
    }

    @WritingConverter
    static enum UUIDToStringConverter implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source.toString();
        }
    }

    @WritingConverter
    static enum BigDecimalToDoubleConverter implements Converter<BigDecimal, Double>
    {
        INSTANCE;


        public Double convert(BigDecimal source) {
            return (Double)NumberUtils.convertNumberToTargetClass((Number)source, Double.class);
        }
    }

    @ReadingConverter
    static enum DoubleToBigDecimalConverter implements Converter<Double, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(Double source) {
            return (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)source, BigDecimal.class);
        }
    }

    @WritingConverter
    static enum ByteArrayToBase64Converter implements Converter<byte[], String>
    {
        INSTANCE;


        public String convert(byte[] source) {
            return Base64.getEncoder().encodeToString(source);
        }
    }

    @ReadingConverter
    static enum Base64ToByteArrayConverter implements Converter<String, byte[]>
    {
        INSTANCE;


        public byte[] convert(String source) {
            return Base64.getDecoder().decode(source);
        }
    }
}

