/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchEntityMetadata;
import org.springframework.util.Assert;

public class SimpleElasticsearchEntityMetadata<T>
implements ElasticsearchEntityMetadata<T> {
    private final Class<T> type;
    private final ElasticsearchPersistentEntity<?> entity;

    public SimpleElasticsearchEntityMetadata(Class<T> type, ElasticsearchPersistentEntity<?> entity) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.type = type;
        this.entity = entity;
    }

    @Override
    public String getIndexName() {
        return this.entity.getIndexCoordinates().getIndexName();
    }

    public Class<T> getJavaType() {
        return this.type;
    }
}

