/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.erhlc;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.RestStatusException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class ElasticsearchExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        ElasticsearchException elasticsearchException;
        RestStatusException restStatusException;
        Throwable cause;
        if (this.isSeqNoConflict(ex)) {
            return new OptimisticLockingFailureException("Cannot index a document due to seq_no+primary_term conflict", (Throwable)ex);
        }
        if (ex instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException2 = (ElasticsearchException)ex;
            if (!this.indexAvailable(elasticsearchException2)) {
                return new NoSuchIndexException(ObjectUtils.nullSafeToString((Object)elasticsearchException2.getMetadata("es.index")), ex);
            }
            if (elasticsearchException2 instanceof ElasticsearchStatusException) {
                ElasticsearchStatusException elasticsearchStatusException = (ElasticsearchStatusException)elasticsearchException2;
                return new RestStatusException(elasticsearchStatusException.status().getStatus(), elasticsearchStatusException.getMessage(), (Throwable)elasticsearchStatusException);
            }
            return new UncategorizedElasticsearchException(ex.getMessage(), ex);
        }
        if (ex instanceof RestStatusException && (cause = (restStatusException = (RestStatusException)((Object)ex)).getCause()) instanceof ElasticsearchException && !this.indexAvailable(elasticsearchException = (ElasticsearchException)cause)) {
            return new NoSuchIndexException(ObjectUtils.nullSafeToString((Object)elasticsearchException.getMetadata("es.index")), ex);
        }
        if (ex instanceof ValidationException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        Throwable cause2 = ex.getCause();
        if (cause2 instanceof IOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private boolean isSeqNoConflict(Exception exception) {
        Object statusException;
        Integer status = null;
        String message = null;
        if (exception instanceof ElasticsearchStatusException) {
            statusException = (ElasticsearchStatusException)exception;
            status = statusException.status().getStatus();
            message = statusException.getMessage();
        }
        if (exception instanceof RestStatusException) {
            statusException = (RestStatusException)((Object)exception);
            status = ((RestStatusException)((Object)statusException)).getStatus();
            message = statusException.getMessage();
        }
        if (status != null && message != null) {
            return status == 409 && message.contains("type=version_conflict_engine_exception") && message.contains("version conflict, required seqNo");
        }
        if (exception instanceof VersionConflictEngineException) {
            VersionConflictEngineException versionConflictEngineException = (VersionConflictEngineException)exception;
            return versionConflictEngineException.getMessage() != null && versionConflictEngineException.getMessage().contains("version conflict, required seqNo");
        }
        return false;
    }

    private boolean indexAvailable(ElasticsearchException ex) {
        List metadata = ex.getMetadata("es.index_uuid");
        if (metadata == null) {
            if (ex.getCause() instanceof ElasticsearchException) {
                return this.indexAvailable((ElasticsearchException)ex.getCause());
            }
            if (ex instanceof ElasticsearchStatusException) {
                return StringUtils.hasText((String)ObjectUtils.nullSafeToString((Object)ex.getIndex()));
            }
            return true;
        }
        return !CollectionUtils.contains(metadata.iterator(), (Object)"_na_");
    }
}

