/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.StringQueryUtil;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public class ElasticsearchStringQuery
extends AbstractElasticsearchRepositoryQuery {
    private final String queryString;

    public ElasticsearchStringQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, String queryString) {
        super(queryMethod, elasticsearchOperations);
        Assert.notNull((Object)queryString, (String)"Query cannot be empty");
        this.queryString = queryString;
    }

    @Override
    public boolean isCountQuery() {
        return this.queryMethod.hasCountQueryAnnotation();
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor parameterAccessor) {
        String queryString = new StringQueryUtil(this.elasticsearchOperations.getElasticsearchConverter().getConversionService()).replacePlaceholders(this.queryString, (ParameterAccessor)parameterAccessor);
        return new StringQuery(queryString);
    }
}

