/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.core.ReactiveResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ReactiveMappingBuilder
extends MappingBuilder {
    public ReactiveMappingBuilder(ElasticsearchConverter elasticsearchConverter) {
        super(elasticsearchConverter);
    }

    @Override
    public String buildPropertyMapping(Class<?> clazz) throws MappingException {
        throw new UnsupportedOperationException("Use ReactiveMappingBuilder.buildReactivePropertyMapping() instead of buildPropertyMapping()");
    }

    public Mono<String> buildReactivePropertyMapping(Class<?> clazz) throws MappingException {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
        return this.getRuntimeFields(entity).switchIfEmpty(Mono.just((Object)Document.create())).map(document -> {
            if (document.isEmpty()) {
                return this.buildPropertyMapping(entity, null);
            }
            return this.buildPropertyMapping(entity, (Document)document);
        });
    }

    private Mono<Document> getRuntimeFields(@Nullable ElasticsearchPersistentEntity<?> entity) {
        String runtimeFieldsPath;
        Mapping mappingAnnotation;
        if (entity != null && (mappingAnnotation = (Mapping)entity.findAnnotation(Mapping.class)) != null && StringUtils.hasText((String)(runtimeFieldsPath = mappingAnnotation.runtimeFieldsPath()))) {
            return ReactiveResourceUtil.readFileFromClasspath(runtimeFieldsPath).map(Document::parse);
        }
        return Mono.empty();
    }
}

