/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.explain.Explanation;
import co.elastic.clients.elasticsearch.core.explain.ExplanationDetail;
import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.NestedIdentity;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.client.elc.ResponseConverter;
import org.springframework.data.elasticsearch.client.elc.SearchDocumentResponseBuilder;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentAdapter;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DocumentAdapters {
    private static final Log LOGGER = LogFactory.getLog(DocumentAdapters.class);

    private DocumentAdapters() {
    }

    public static SearchDocument from(Hit<?> hit, JsonpMapper jsonpMapper) {
        Document document;
        Assert.notNull(hit, (String)"hit must not be null");
        Map highlightFields = hit.highlight();
        LinkedHashMap<String, SearchDocumentResponse> innerHits = new LinkedHashMap<String, SearchDocumentResponse>();
        hit.innerHits().forEach((name, innerHitsResult) -> innerHits.put((String)name, SearchDocumentResponseBuilder.from(innerHitsResult.hits(), null, null, null, searchDocument -> null, jsonpMapper)));
        NestedMetaData nestedMetaData = DocumentAdapters.from(hit.nested());
        org.springframework.data.elasticsearch.core.document.Explanation explanation = DocumentAdapters.from(hit.explanation());
        List matchedQueries = hit.matchedQueries();
        Function<Map, EntityAsMap> fromFields = fields -> {
            StringBuilder sb = new StringBuilder("{");
            boolean[] firstField = new boolean[]{true};
            hit.fields().forEach((key, jsonData) -> {
                if (!firstField[0]) {
                    sb.append(',');
                }
                sb.append('\"').append((String)key).append("\":").append(jsonData.toJson(jsonpMapper).toString());
                firstField[0] = false;
            });
            sb.append('}');
            return (EntityAsMap)new EntityAsMap().fromJson(sb.toString());
        };
        EntityAsMap hitFieldsAsMap = fromFields.apply(hit.fields());
        LinkedHashMap<String, List<Object>> documentFields = new LinkedHashMap<String, List<Object>>();
        hitFieldsAsMap.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof List) {
                documentFields.put((String)entry.getKey(), (List)entry.getValue());
            } else {
                documentFields.put((String)entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        });
        Object source = hit.source();
        if (source == null) {
            document = Document.from(hitFieldsAsMap);
        } else if (source instanceof EntityAsMap) {
            document = Document.from((EntityAsMap)source);
        } else if (source instanceof JsonData) {
            JsonData jsonData = (JsonData)source;
            document = Document.from((Map)jsonData.to(EntityAsMap.class));
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)String.format("Cannot map from type " + source.getClass().getName(), new Object[0]));
            }
            document = Document.create();
        }
        document.setIndex(hit.index());
        document.setId(hit.id());
        if (hit.version() != null) {
            document.setVersion(hit.version());
        }
        document.setSeqNo(hit.seqNo() != null && hit.seqNo() >= 0L ? hit.seqNo() : -2L);
        document.setPrimaryTerm(hit.primaryTerm() != null && hit.primaryTerm() > 0L ? hit.primaryTerm() : 0L);
        float score = hit.score() != null ? hit.score().floatValue() : Float.NaN;
        return new SearchDocumentAdapter(document, score, hit.sort().toArray(new String[0]), documentFields, highlightFields, innerHits, nestedMetaData, explanation, matchedQueries, hit.routing());
    }

    @Nullable
    private static org.springframework.data.elasticsearch.core.document.Explanation from(@Nullable Explanation explanation) {
        if (explanation == null) {
            return null;
        }
        List<org.springframework.data.elasticsearch.core.document.Explanation> details = explanation.details().stream().map(DocumentAdapters::from).collect(Collectors.toList());
        return new org.springframework.data.elasticsearch.core.document.Explanation(true, Double.valueOf(explanation.value()), explanation.description(), details);
    }

    private static org.springframework.data.elasticsearch.core.document.Explanation from(ExplanationDetail explanationDetail) {
        List<org.springframework.data.elasticsearch.core.document.Explanation> details = explanationDetail.details().stream().map(DocumentAdapters::from).collect(Collectors.toList());
        return new org.springframework.data.elasticsearch.core.document.Explanation(null, Double.valueOf(explanationDetail.value()), explanationDetail.description(), details);
    }

    @Nullable
    private static NestedMetaData from(@Nullable NestedIdentity nestedIdentity) {
        if (nestedIdentity == null) {
            return null;
        }
        NestedMetaData child = DocumentAdapters.from(nestedIdentity.nested());
        return NestedMetaData.of(nestedIdentity.field(), nestedIdentity.offset(), child);
    }

    @Nullable
    public static Document from(GetResult<EntityAsMap> getResponse) {
        Assert.notNull(getResponse, (String)"getResponse must not be null");
        if (!getResponse.found()) {
            return null;
        }
        Document document = getResponse.source() != null ? Document.from((Map)getResponse.source()) : Document.create();
        document.setIndex(getResponse.index());
        document.setId(getResponse.id());
        if (getResponse.version() != null) {
            document.setVersion(getResponse.version());
        }
        if (getResponse.seqNo() != null) {
            document.setSeqNo(getResponse.seqNo());
        }
        if (getResponse.primaryTerm() != null) {
            document.setPrimaryTerm(getResponse.primaryTerm());
        }
        return document;
    }

    public static List<MultiGetItem<Document>> from(MgetResponse<EntityAsMap> mgetResponse) {
        Assert.notNull(mgetResponse, (String)"mgetResponse must not be null");
        return mgetResponse.docs().stream().map(itemResponse -> MultiGetItem.of(itemResponse.isFailure() ? null : DocumentAdapters.from((GetResult<EntityAsMap>)itemResponse.result()), ResponseConverter.getFailure((MultiGetResponseItem<EntityAsMap>)itemResponse))).collect(Collectors.toList());
    }
}

