/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.elasticsearch.ResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class ResourceUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromClasspath(String url) {
        Assert.notNull((Object)url, (String)"url must not be null");
        try (InputStream is = new ClassPathResource(url).getInputStream();){
            String string = StreamUtils.copyToString((InputStream)is, (Charset)Charset.defaultCharset());
            return string;
        }
        catch (Exception e) {
            throw new ResourceFailureException("Could not load resource from " + url, e);
        }
    }

    private ResourceUtil() {
    }
}

