/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleElasticsearchRepository<T, ID>
implements ElasticsearchRepository<T, ID> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchRepository.class);
    protected ElasticsearchOperations operations;
    protected IndexOperations indexOperations;
    protected Class<T> entityClass;
    protected ElasticsearchEntityInformation<T, ID> entityInformation;

    public SimpleElasticsearchRepository(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations operations) {
        this.operations = operations;
        Assert.notNull(metadata, (String)"ElasticsearchEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.entityClass = this.entityInformation.getJavaType();
        this.indexOperations = operations.indexOps(this.entityClass);
        if (this.shouldCreateIndexAndMapping() && !this.indexOperations.exists()) {
            this.indexOperations.createWithMapping();
        }
    }

    private boolean shouldCreateIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityClass);
        return entity.isCreateIndexAndMapping();
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.execute(operations -> operations.get(this.stringIdRepresentation(id), this.entityClass, this.getIndexCoordinates())));
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
    }

    public Page<T> findAll(Pageable pageable) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable(pageable).build();
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        SearchPage page = SearchHitSupport.searchPageFor(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable((Pageable)PageRequest.of((int)0, (int)itemCount, (Sort)sort)).build();
        List searchHitList = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()).getSearchHits());
        return (List)SearchHitSupport.unwrapSearchHits(searchHitList);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        ArrayList result = new ArrayList();
        Query idQuery = this.getIdQuery(ids);
        if (CollectionUtils.isEmpty(idQuery.getIds())) {
            return result;
        }
        List multiGetItems = this.execute(operations -> operations.multiGet(idQuery, this.entityClass, this.getIndexCoordinates()));
        if (multiGetItems != null) {
            multiGetItems.forEach(multiGetItem -> {
                if (multiGetItem.hasItem()) {
                    result.add(multiGetItem.getItem());
                }
            });
        }
        return result;
    }

    public long count() {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        return this.execute(operations -> operations.count(query, this.entityClass, this.getIndexCoordinates()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        return (S)this.executeAndRefresh(operations -> operations.save(entity, this.getIndexCoordinates()));
    }

    public <S extends T> List<S> save(List<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        return Streamable.of(this.saveAll(entities)).stream().collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.executeAndRefresh(operations -> operations.save(entities, indexCoordinates));
        return entities;
    }

    public boolean existsById(ID id) {
        return this.execute(operations -> operations.exists(this.stringIdRepresentation(id), this.getIndexCoordinates()));
    }

    @Override
    public Page<T> searchSimilar(T entity, @Nullable String[] fields, Pageable pageable) {
        Assert.notNull(entity, (String)"Cannot search similar records for 'null'.");
        Assert.notNull((Object)pageable, (String)"'pageable' cannot be 'null'");
        MoreLikeThisQuery query = new MoreLikeThisQuery();
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setPageable(pageable);
        if (fields != null) {
            query.addFields(fields);
        }
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        SearchPage searchPage = SearchHitSupport.searchPageFor(searchHits, pageable);
        return (Page)SearchHitSupport.unwrapSearchHits(searchPage);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.doDelete(id, null, this.getIndexCoordinates());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.doDelete(this.extractIdFromBean(entity), this.operations.getEntityRouting(entity), this.getIndexCoordinates());
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"Cannot delete 'null' list.");
        ArrayList<String> idStrings = new ArrayList<String>();
        for (ID id : ids) {
            idStrings.add(this.stringIdRepresentation(id));
        }
        if (idStrings.isEmpty()) {
            return;
        }
        Query query = this.operations.idsQuery(idStrings);
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, this.getIndexCoordinates());
            return null;
        });
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        ArrayList<ID> ids = new ArrayList<ID>();
        for (T entity : entities) {
            ID id = this.extractIdFromBean(entity);
            if (id == null) continue;
            ids.add(id);
        }
        this.deleteAllById(ids);
    }

    private void doDelete(@Nullable ID id, @Nullable String routing, IndexCoordinates indexCoordinates) {
        if (id != null) {
            this.executeAndRefresh(operations -> operations.delete(this.stringIdRepresentation(id), routing, indexCoordinates));
        }
    }

    public void deleteAll() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, indexCoordinates);
            return null;
        });
    }

    private void doRefresh() {
        RefreshPolicy refreshPolicy = null;
        if (this.operations instanceof AbstractElasticsearchTemplate) {
            refreshPolicy = ((AbstractElasticsearchTemplate)this.operations).getRefreshPolicy();
        }
        if (refreshPolicy == null) {
            this.indexOperations.refresh();
        }
    }

    @Nullable
    protected ID extractIdFromBean(T entity) {
        return (ID)this.entityInformation.getId(entity);
    }

    private List<String> stringIdsRepresentation(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        return StreamUtils.createStreamFromIterator(ids.iterator()).map(id -> this.stringIdRepresentation(id)).collect(Collectors.toList());
    }

    @Nullable
    protected String stringIdRepresentation(@Nullable ID id) {
        return this.operations.stringIdRepresentation(id);
    }

    private IndexCoordinates getIndexCoordinates() {
        return this.operations.getIndexCoordinatesFor(this.entityClass);
    }

    private Query getIdQuery(Iterable<? extends ID> ids) {
        List<String> stringIds = this.stringIdsRepresentation(ids);
        return new NativeSearchQueryBuilder().withIds(stringIds).build();
    }

    @Nullable
    public <R> R execute(OperationsCallback<R> callback) {
        return callback.doWithOperations(this.operations);
    }

    @Nullable
    public <R> R executeAndRefresh(OperationsCallback<R> callback) {
        R result = callback.doWithOperations(this.operations);
        this.doRefresh();
        return result;
    }

    @FunctionalInterface
    public static interface OperationsCallback<R> {
        @Nullable
        public R doWithOperations(ElasticsearchOperations var1);
    }
}

