/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.data.elasticsearch.ResourceFailureException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class ReactiveResourceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveResourceUtil.class);
    private static final int BUFFER_SIZE = 8192;

    public static Mono<String> readFileFromClasspath(String url) {
        Assert.notNull((Object)url, (String)"url must not be null");
        return DataBufferUtils.join((Publisher)DataBufferUtils.read((Resource)new ClassPathResource(url), (DataBufferFactory)new DefaultDataBufferFactory(), (int)8192)).handle((it, sink) -> {
            try (InputStream is = it.asInputStream();
                 InputStreamReader in = new InputStreamReader(is, Charset.defaultCharset());
                 BufferedReader br = new BufferedReader(in);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                sink.next((Object)sb.toString());
                sink.complete();
            }
            catch (Exception e) {
                sink.complete();
            }
            finally {
                DataBufferUtils.release((DataBuffer)it);
            }
        }).onErrorResume(throwable -> Mono.error((Throwable)((Object)new ResourceFailureException("Could not load resource from " + url, (Throwable)throwable))));
    }

    private ReactiveResourceUtil() {
    }
}

