/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractIndexTemplate
implements IndexOperations {
    protected final ElasticsearchConverter elasticsearchConverter;
    protected final RequestFactory requestFactory;
    @Nullable
    protected final Class<?> boundClass;
    @Nullable
    private final IndexCoordinates boundIndex;

    public AbstractIndexTemplate(ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        Assert.notNull(boundClass, (String)"boundClass may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = boundClass;
        this.boundIndex = null;
    }

    public AbstractIndexTemplate(ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        Assert.notNull((Object)boundIndex, (String)"boundIndex may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = null;
        this.boundIndex = boundIndex;
    }

    protected Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }

    @Override
    public boolean create() {
        Settings settings = this.boundClass != null ? this.createSettings(this.boundClass) : new Settings();
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public Settings createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? Settings.parse(ResourceUtil.readFileFromClasspath(settingPath)) : persistentEntity.getDefaultSettings();
    }

    @Override
    public boolean createWithMapping() {
        return this.doCreate(this.getIndexCoordinates(), this.createSettings(), this.createMapping());
    }

    @Override
    public boolean create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public boolean create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    protected abstract boolean doCreate(IndexCoordinates var1, Map<String, Object> var2, @Nullable Document var3);

    @Override
    public boolean delete() {
        return this.doDelete(this.getIndexCoordinates());
    }

    protected abstract boolean doDelete(IndexCoordinates var1);

    @Override
    public boolean exists() {
        return this.doExists(this.getIndexCoordinates());
    }

    protected abstract boolean doExists(IndexCoordinates var1);

    @Override
    public boolean putMapping(Document mapping) {
        return this.doPutMapping(this.getIndexCoordinates(), mapping);
    }

    protected abstract boolean doPutMapping(IndexCoordinates var1, Document var2);

    @Override
    public Map<String, Object> getMapping() {
        return this.doGetMapping(this.getIndexCoordinates());
    }

    protected abstract Map<String, Object> doGetMapping(IndexCoordinates var1);

    @Override
    public Settings getSettings() {
        return this.getSettings(false);
    }

    @Override
    public Settings getSettings(boolean includeDefaults) {
        return this.doGetSettings(this.getIndexCoordinates(), includeDefaults);
    }

    protected abstract Settings doGetSettings(IndexCoordinates var1, boolean var2);

    @Override
    public void refresh() {
        this.doRefresh(this.getIndexCoordinates());
    }

    protected abstract void doRefresh(IndexCoordinates var1);

    @Override
    public Map<String, Set<AliasData>> getAliases(String ... aliasNames) {
        Assert.notEmpty((Object[])aliasNames, (String)"aliasNames must not be empty");
        return this.doGetAliases(aliasNames, null);
    }

    @Override
    public Map<String, Set<AliasData>> getAliasesForIndex(String ... indexNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames must not be empty");
        return this.doGetAliases(null, indexNames);
    }

    protected abstract Map<String, Set<AliasData>> doGetAliases(@Nullable String[] var1, @Nullable String[] var2);

    @Override
    public Document createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Document createMapping(Class<?> clazz) {
        return this.buildMapping(clazz);
    }

    protected Document buildMapping(Class<?> clazz) {
        String mappings;
        String mappingPath;
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath())) && StringUtils.hasText((String)(mappings = ResourceUtil.readFileFromClasspath(mappingPath)))) {
            return Document.parse(mappings);
        }
        try {
            String mapping = new MappingBuilder(this.elasticsearchConverter).buildPropertyMapping(clazz);
            return Document.parse(mapping);
        }
        catch (Exception e) {
            throw new UncategorizedElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public Settings createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndex);
    }

    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }
}

