/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.Map;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.lang.Nullable;

public class TemplateData {
    @Nullable
    private final String[] indexPatterns;
    @Nullable
    Settings settings;
    @Nullable
    Document mapping;
    @Nullable
    private final Map<String, AliasData> aliases;
    int order;
    @Nullable
    Integer version;

    private TemplateData(@Nullable String[] indexPatterns, @Nullable Settings settings, @Nullable Document mapping, @Nullable Map<String, AliasData> aliases, int order, @Nullable Integer version) {
        this.indexPatterns = indexPatterns;
        this.settings = settings;
        this.mapping = mapping;
        this.order = order;
        this.version = version;
        this.aliases = aliases;
    }

    public static TemplateDataBuilder builder() {
        return new TemplateDataBuilder();
    }

    @Nullable
    public String[] getIndexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public Document getMapping() {
        return this.mapping;
    }

    @Nullable
    public Map<String, AliasData> getAliases() {
        return this.aliases;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public static final class TemplateDataBuilder {
        @Nullable
        Settings settings;
        @Nullable
        Document mapping;
        int order;
        @Nullable
        Integer version;
        @Nullable
        private String[] indexPatterns;
        @Nullable
        private Map<String, AliasData> aliases;

        private TemplateDataBuilder() {
        }

        public TemplateDataBuilder withIndexPatterns(String[] indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public TemplateDataBuilder withSettings(Map<String, Object> settings) {
            this.settings = new Settings(settings);
            return this;
        }

        public TemplateDataBuilder withMapping(Document mapping) {
            this.mapping = mapping;
            return this;
        }

        public TemplateDataBuilder withOrder(int order) {
            this.order = order;
            return this;
        }

        public TemplateDataBuilder withVersion(Integer version) {
            this.version = version;
            return this;
        }

        public TemplateDataBuilder withAliases(Map<String, AliasData> aliases) {
            this.aliases = aliases;
            return this;
        }

        public TemplateData build() {
            return new TemplateData(this.indexPatterns, this.settings, this.mapping, this.aliases, this.order, this.version);
        }
    }
}

