/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.elasticsearch.core.convert.DateTimeConverters;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchStringQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

public final class StringQueryUtil {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final ConversionService conversionService;
    private final GenericConversionService genericConversionService;

    public StringQueryUtil(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
        this.genericConversionService = this.setupGenericConversionService();
    }

    private GenericConversionService setupGenericConversionService() {
        GenericConversionService genericConversionService = new GenericConversionService();
        if (!genericConversionService.canConvert(Date.class, String.class)) {
            genericConversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (ClassUtils.isPresent((String)"org.joda.time.DateTimeZone", (ClassLoader)ElasticsearchStringQuery.class.getClassLoader())) {
            if (!genericConversionService.canConvert(ReadableInstant.class, String.class)) {
                genericConversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!genericConversionService.canConvert(LocalDateTime.class, String.class)) {
                genericConversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        return genericConversionService;
    }

    public String replacePlaceholders(String input, ParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String placeholder = Pattern.quote(matcher.group()) + "(?!\\d+)";
            int index = (Integer)NumberUtils.parseNumber((String)matcher.group(1), Integer.class);
            result = result.replaceAll(placeholder, Matcher.quoteReplacement(this.getParameterWithIndex(accessor, index)));
        }
        return result;
    }

    private String getParameterWithIndex(ParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        String parameterValue = "null";
        if (parameter != null) {
            parameterValue = this.convert(parameter);
        }
        return parameterValue;
    }

    private String convert(Object parameter) {
        if (Collection.class.isAssignableFrom(parameter.getClass())) {
            Collection collectionParam = (Collection)parameter;
            StringBuilder sb = new StringBuilder("[");
            sb.append(collectionParam.stream().map(o -> {
                if (o instanceof String) {
                    return "\"" + this.convert(o) + "\"";
                }
                return this.convert(o);
            }).collect(Collectors.joining(",")));
            sb.append("]");
            return sb.toString();
        }
        String parameterValue = "null";
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            String converted = (String)this.conversionService.convert(parameter, String.class);
            if (converted != null) {
                parameterValue = converted;
            }
        } else if (this.genericConversionService.canConvert(parameter.getClass(), String.class)) {
            String converted = (String)this.genericConversionService.convert(parameter, String.class);
            if (converted != null) {
                parameterValue = converted;
            }
        } else {
            parameterValue = parameter.toString();
        }
        parameterValue = parameterValue.replaceAll("\"", Matcher.quoteReplacement("\\\""));
        return parameterValue;
    }
}

