/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleElasticsearchRepository<T, ID>
implements ElasticsearchRepository<T, ID> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchRepository.class);
    protected ElasticsearchOperations operations;
    protected IndexOperations indexOperations;
    protected Class<T> entityClass;
    protected ElasticsearchEntityInformation<T, ID> entityInformation;

    public SimpleElasticsearchRepository(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations operations) {
        this.operations = operations;
        Assert.notNull(metadata, (String)"ElasticsearchEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.entityClass = this.entityInformation.getJavaType();
        this.indexOperations = operations.indexOps(this.entityClass);
        try {
            if (this.shouldCreateIndexAndMapping() && !this.indexOperations.exists()) {
                this.indexOperations.create();
                this.indexOperations.putMapping(this.entityClass);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Cannot create index: {}", (Object)exception.getMessage());
        }
    }

    private boolean shouldCreateIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityClass);
        return entity.isCreateIndexAndMapping();
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.execute(operations -> operations.get(this.stringIdRepresentation(id), this.entityClass, this.getIndexCoordinates())));
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
    }

    public Page<T> findAll(Pageable pageable) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable(pageable).build();
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        AggregatedPage page = SearchHitSupport.page(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable((Pageable)PageRequest.of((int)0, (int)itemCount, (Sort)sort)).build();
        List searchHitList = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()).getSearchHits());
        return (List)SearchHitSupport.unwrapSearchHits(searchHitList);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        ArrayList result = new ArrayList();
        List<String> stringIds = this.stringIdsRepresentation(ids);
        if (stringIds.isEmpty()) {
            return result;
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withIds(stringIds).build();
        List multiGetEntities = this.execute(operations -> operations.multiGet(query, this.entityClass, this.getIndexCoordinates()));
        if (multiGetEntities != null) {
            multiGetEntities.forEach(entity -> {
                if (entity != null) {
                    result.add(entity);
                }
            });
        }
        return result;
    }

    public long count() {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        return this.execute(operations -> operations.count(query, this.entityClass, this.getIndexCoordinates()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        return (S)this.executeAndRefresh(operations -> operations.save(entity, this.getIndexCoordinates()));
    }

    public <S extends T> List<S> save(List<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        return Streamable.of(this.saveAll(entities)).stream().collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public <S extends T> S indexWithoutRefresh(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        return (S)this.execute(operations -> operations.save(entity));
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.executeAndRefresh(operations -> operations.save(entities, indexCoordinates));
        return entities;
    }

    public boolean existsById(ID id) {
        return this.execute(operations -> operations.exists(this.stringIdRepresentation(id), this.getIndexCoordinates()));
    }

    @Override
    public Iterable<T> search(QueryBuilder query) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).build();
        long count = this.execute(operations -> operations.count(searchQuery, this.entityClass, this.getIndexCoordinates()));
        if (count == 0L) {
            return new PageImpl(Collections.emptyList());
        }
        searchQuery.setPageable((Pageable)PageRequest.of((int)0, (int)((int)count)));
        SearchHits searchHits = this.execute(operations -> operations.search(searchQuery, this.entityClass, this.getIndexCoordinates()));
        AggregatedPage page = SearchHitSupport.page(searchHits, searchQuery.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> search(QueryBuilder query, Pageable pageable) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).withPageable(pageable).build();
        SearchHits searchHits = this.execute(operations -> operations.search(searchQuery, this.entityClass, this.getIndexCoordinates()));
        AggregatedPage page = SearchHitSupport.page(searchHits, searchQuery.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> search(Query query) {
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        AggregatedPage page = SearchHitSupport.page(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> searchSimilar(T entity, @Nullable String[] fields, Pageable pageable) {
        Assert.notNull(entity, (String)"Cannot search similar records for 'null'.");
        Assert.notNull((Object)pageable, (String)"'pageable' cannot be 'null'");
        MoreLikeThisQuery query = new MoreLikeThisQuery();
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setPageable(pageable);
        if (fields != null) {
            query.addFields(fields);
        }
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        AggregatedPage page = SearchHitSupport.page(searchHits, pageable);
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.doDelete(id, null, this.getIndexCoordinates());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.doDelete(this.extractIdFromBean(entity), this.operations.getEntityRouting(entity), this.getIndexCoordinates());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery();
        for (T entity : entities) {
            ID id = this.extractIdFromBean(entity);
            if (id == null) continue;
            idsQueryBuilder.addIds(new String[]{this.stringIdRepresentation(id)});
        }
        if (idsQueryBuilder.ids().isEmpty()) {
            return;
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)idsQueryBuilder).build();
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, indexCoordinates);
            return null;
        });
    }

    private void doDelete(@Nullable ID id, @Nullable String routing, IndexCoordinates indexCoordinates) {
        if (id != null) {
            this.executeAndRefresh(operations -> operations.delete(this.stringIdRepresentation(id), routing, indexCoordinates));
        }
    }

    public void deleteAll() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, indexCoordinates);
            return null;
        });
    }

    @Override
    public void refresh() {
        this.indexOperations.refresh();
    }

    @Nullable
    protected ID extractIdFromBean(T entity) {
        return (ID)this.entityInformation.getId(entity);
    }

    private List<String> stringIdsRepresentation(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        return StreamUtils.createStreamFromIterator(ids.iterator()).map(id -> this.stringIdRepresentation(id)).collect(Collectors.toList());
    }

    @Nullable
    protected String stringIdRepresentation(@Nullable ID id) {
        return this.operations.stringIdRepresentation(id);
    }

    private IndexCoordinates getIndexCoordinates() {
        return this.operations.getIndexCoordinatesFor(this.entityClass);
    }

    @Nullable
    public <R> R execute(OperationsCallback<R> callback) {
        return callback.doWithOperations(this.operations);
    }

    @Nullable
    public <R> R executeAndRefresh(OperationsCallback<R> callback) {
        R result = callback.doWithOperations(this.operations);
        this.refresh();
        return result;
    }

    @FunctionalInterface
    public static interface OperationsCallback<R> {
        @Nullable
        public R doWithOperations(ElasticsearchOperations var1);
    }
}

