/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchTypeMapper;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ElasticsearchEntityMapper
implements EntityConverter<ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty, Object, Map<String, Object>>,
EntityWriter<Object, Map<String, Object>>,
EntityReader<Object, Map<String, Object>>,
InitializingBean,
EntityMapper {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final GenericConversionService conversionService;
    private final ObjectReader objectReader;
    private final ObjectWriter objectWriter;
    private CustomConversions conversions = new ElasticsearchCustomConversions(Collections.emptyList());
    private EntityInstantiators instantiators = new EntityInstantiators();
    private ElasticsearchTypeMapper typeMapper;

    public ElasticsearchEntityMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, @Nullable GenericConversionService conversionService) {
        this.mappingContext = mappingContext;
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        this.typeMapper = ElasticsearchTypeMapper.create(mappingContext);
        ObjectMapper objectMapper = new ObjectMapper();
        this.objectReader = objectMapper.readerFor(HashMap.class);
        this.objectWriter = objectMapper.writer();
    }

    public MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    public void setTypeMapper(ElasticsearchTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void afterPropertiesSet() {
        DateFormatterRegistrar.addDateConverters((ConverterRegistry)this.conversionService);
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public <T> T readObject(Map<String, Object> source, Class<T> targetType) {
        return this.read(targetType, source);
    }

    @Nullable
    public <R> R read(Class<R> type, Map<String, Object> source) {
        return this.doRead(source, (TypeInformation<R>)ClassTypeInformation.from((Class)ClassUtils.getUserClass(type)));
    }

    @Nullable
    protected <R> R doRead(Map<String, Object> source, TypeInformation<R> typeHint) {
        if (source == null) {
            return null;
        }
        if (this.conversions.hasCustomReadTarget(Map.class, (typeHint = this.typeMapper.readType(source, typeHint)).getType())) {
            return (R)this.conversionService.convert(source, typeHint.getType());
        }
        if (typeHint.isMap() || ClassTypeInformation.OBJECT.equals((Object)typeHint)) {
            return (R)source;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeHint);
        return this.readEntity(entity, source);
    }

    protected <R> R readEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        ElasticsearchPersistentEntity<?> targetEntity = this.computeClosestEntity(entity, source);
        ElasticsearchPropertyValueProvider propertyValueProvider = new ElasticsearchPropertyValueProvider(new MapValueAccessor(source));
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(targetEntity);
        Object instance = instantiator.createInstance(targetEntity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(targetEntity, (PropertyValueProvider)propertyValueProvider, null));
        return (R)(targetEntity.requiresPropertyPopulation() ? this.readProperties(targetEntity, instance, propertyValueProvider) : instance);
    }

    protected <R> R readProperties(ElasticsearchPersistentEntity<?> entity, R instance, ElasticsearchPropertyValueProvider valueProvider) {
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            ElasticsearchPersistentProperty prop = (ElasticsearchPersistentProperty)iterator.next();
            if (entity.isConstructorArgument(prop) || prop.isScoreProperty() || (value = valueProvider.getPropertyValue(prop)) == null) continue;
            accessor.setProperty((PersistentProperty)prop, valueProvider.getPropertyValue(prop));
        }
        return (R)accessor.getBean();
    }

    protected <R> R readValue(@Nullable Object source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        if (source == null) {
            return null;
        }
        Class rawType = targetType.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), rawType)) {
            return (R)rawType.cast(this.conversionService.convert(source, rawType));
        }
        if (source instanceof List) {
            return this.readCollectionValue((List)source, property, targetType);
        }
        if (source instanceof Map) {
            return this.readMapValue((Map)source, property, targetType);
        }
        return (R)this.readSimpleValue(source, targetType);
    }

    private <R> R readMapValue(@Nullable Map<String, Object> source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        TypeInformation information = this.typeMapper.readType(source);
        if (property.isEntity() && !property.isMap() || information != null) {
            ElasticsearchPersistentEntity targetEntity = information != null ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(information) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
            return this.readEntity(targetEntity, source);
        }
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                target.put(entryKey, null);
                continue;
            }
            if (this.isSimpleType(entryValue)) {
                target.put(entryKey, this.readSimpleValue(entryValue, targetType.isMap() ? targetType.getComponentType() : targetType));
                continue;
            }
            ElasticsearchPersistentEntity<?> targetEntity = this.computeGenericValueTypeForRead(property, entryValue);
            if (targetEntity.getTypeInformation().isMap()) {
                Map valueMap = (Map)entryValue;
                if (this.typeMapper.containsTypeInformation(valueMap)) {
                    target.put(entryKey, this.readEntity(targetEntity, (Map)entryValue));
                    continue;
                }
                target.put(entryKey, this.readValue(valueMap, property, targetEntity.getTypeInformation()));
                continue;
            }
            if (targetEntity.getTypeInformation().isCollectionLike()) {
                target.put(entryKey, this.readValue(entryValue, property, targetEntity.getTypeInformation().getActualType()));
                continue;
            }
            target.put(entryKey, this.readEntity(targetEntity, (Map)entryValue));
        }
        return (R)target;
    }

    private <R> R readCollectionValue(@Nullable List<?> source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        if (source == null) {
            return null;
        }
        Collection<Object> target = this.createCollectionForValue(targetType, source.size());
        for (Object value : source) {
            if (value == null) {
                target.add(null);
                continue;
            }
            if (this.isSimpleType(value)) {
                target.add(this.readSimpleValue(value, targetType.getComponentType() != null ? targetType.getComponentType() : targetType));
                continue;
            }
            if (value instanceof List) {
                target.add(this.readValue(value, property, property.getTypeInformation().getActualType()));
                continue;
            }
            target.add(this.readEntity(this.computeGenericValueTypeForRead(property, value), (Map)value));
        }
        return (R)target;
    }

    private Object readSimpleValue(@Nullable Object value, TypeInformation<?> targetType) {
        Class target = targetType.getType();
        if (value == null || target == null || ClassUtils.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    @Override
    public Map<String, Object> mapObject(Object source) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        this.write(source, target);
        return target;
    }

    public void write(@Nullable Object source, Map<String, Object> sink) {
        if (source == null) {
            return;
        }
        if (source instanceof Map) {
            sink.putAll((Map)source);
            return;
        }
        Class entityType = ClassUtils.getUserClass(source.getClass());
        ClassTypeInformation type = ClassTypeInformation.from((Class)entityType);
        if (this.requiresTypeHint((TypeInformation<?>)type, source.getClass(), null)) {
            this.typeMapper.writeType(source.getClass(), sink);
        }
        this.doWrite(source, sink, (TypeInformation<? extends Object>)type);
    }

    protected void doWrite(@Nullable Object source, Map<String, Object> sink, @Nullable TypeInformation<? extends Object> typeHint) {
        if (source == null) {
            return;
        }
        Class<?> entityType = source.getClass();
        Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Map.class);
        if (customTarget.isPresent()) {
            sink.putAll((Map)this.conversionService.convert(source, Map.class));
            return;
        }
        if (typeHint != null) {
            ElasticsearchPersistentEntity entity = typeHint.getType().equals(entityType) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeHint) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
            this.writeEntity(entity, source, sink, null);
            return;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeEntity(entity, source, sink, null);
    }

    protected void writeEntity(ElasticsearchPersistentEntity<?> entity, Object source, Map<String, Object> sink, @Nullable TypeInformation containingStructure) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        if (this.requiresTypeHint(entity.getTypeInformation(), source.getClass(), containingStructure)) {
            this.typeMapper.writeType(source.getClass(), sink);
        }
        this.writeProperties(entity, accessor, sink);
    }

    protected void writeProperties(ElasticsearchPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, Map<String, Object> sink) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
            if (!property.isWritable() || (value = accessor.getProperty((PersistentProperty)property)) == null) continue;
            if (!this.isSimpleType(value)) {
                this.writeProperty(property, value, sink);
                continue;
            }
            sink.put(property.getFieldName(), this.getWriteSimpleValue(value));
        }
    }

    protected void writeProperty(ElasticsearchPersistentProperty property, Object value, Map<String, Object> sink) {
        Optional customWriteTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customWriteTarget.isPresent()) {
            Class writeTarget = (Class)customWriteTarget.get();
            sink.put(property.getFieldName(), this.conversionService.convert(value, writeTarget));
            return;
        }
        TypeInformation typeHint = property.getTypeInformation();
        if (typeHint.equals(ClassTypeInformation.OBJECT)) {
            if (value instanceof List) {
                typeHint = ClassTypeInformation.LIST;
            } else if (value instanceof Map) {
                typeHint = ClassTypeInformation.MAP;
            } else if (value instanceof Set) {
                typeHint = ClassTypeInformation.SET;
            } else if (value instanceof Collection) {
                typeHint = ClassTypeInformation.COLLECTION;
            }
        }
        sink.put(property.getFieldName(), this.getWriteComplexValue(property, typeHint, value));
    }

    protected Object getWriteSimpleValue(Object value) {
        if (value == null) {
            return null;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected Object getWriteComplexValue(ElasticsearchPersistentProperty property, TypeInformation<?> typeHint, Object value) {
        if (typeHint.isCollectionLike() || value instanceof Iterable) {
            return this.writeCollectionValue(value, property, typeHint);
        }
        if (typeHint.isMap()) {
            return this.writeMapValue((Map)value, property, typeHint);
        }
        if (property.isEntity() || !this.isSimpleType(value)) {
            return this.writeEntity(value, property, typeHint);
        }
        return value;
    }

    private Object writeEntity(Object value, ElasticsearchPersistentProperty property, TypeInformation<?> typeHint) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        this.writeEntity((ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()), value, target, property.getTypeInformation());
        return target;
    }

    private Object writeMapValue(Map<String, Object> value, ElasticsearchPersistentProperty property, TypeInformation<?> typeHint) {
        LinkedHashMap target = new LinkedHashMap();
        Streamable mapSource = Streamable.of(value.entrySet());
        if (!typeHint.getActualType().getType().equals(Object.class) && this.isSimpleType(typeHint.getMapValueType().getType())) {
            mapSource.forEach(it -> {
                if (it.getValue() == null) {
                    target.put(it.getKey(), null);
                } else {
                    target.put(it.getKey(), this.getWriteSimpleValue(it.getValue()));
                }
            });
        } else {
            mapSource.forEach(it -> {
                Object converted = null;
                if (it.getValue() != null) {
                    converted = this.isSimpleType(it.getValue()) ? this.getWriteSimpleValue(it.getValue()) : this.getWriteComplexValue(property, (TypeInformation<?>)ClassTypeInformation.from(it.getValue().getClass()), it.getValue());
                }
                target.put(it.getKey(), converted);
            });
        }
        return target;
    }

    private Object writeCollectionValue(Object value, ElasticsearchPersistentProperty property, TypeInformation<?> typeHint) {
        Streamable collectionSource = value instanceof Iterable ? Streamable.of((Iterable)((Iterable)value)) : Streamable.of((Object[])ObjectUtils.toObjectArray((Object)value));
        ArrayList target = new ArrayList();
        if (!typeHint.getActualType().getType().equals(Object.class) && this.isSimpleType(typeHint.getActualType().getType())) {
            collectionSource.map(this::getWriteSimpleValue).forEach(target::add);
        } else {
            collectionSource.map(it -> {
                if (it == null) {
                    return null;
                }
                if (this.isSimpleType(it)) {
                    return this.getWriteSimpleValue(it);
                }
                return this.getWriteComplexValue(property, (TypeInformation<?>)ClassTypeInformation.from(it.getClass()), it);
            }).forEach(target::add);
        }
        return target;
    }

    @Override
    public String mapToString(Object source) throws IOException {
        LinkedHashMap<String, Object> sink = new LinkedHashMap<String, Object>();
        this.write(source, sink);
        return this.objectWriter.writeValueAsString(sink);
    }

    @Override
    public <T> T mapToObject(String source, Class<T> clazz) throws IOException {
        return this.read(clazz, (Map)this.objectReader.readValue(source));
    }

    private boolean requiresTypeHint(TypeInformation<?> type, Class<?> actualType, @Nullable TypeInformation<?> container) {
        if (container != null) {
            if (container.isCollectionLike() && type.equals((Object)container.getActualType()) && type.getType().equals(actualType)) {
                return false;
            }
            if (container.isMap() && type.equals((Object)container.getMapValueType()) && type.getType().equals(actualType)) {
                return false;
            }
            if (container.equals(type) && type.getType().equals(actualType)) {
                return false;
            }
        }
        return !this.conversions.isSimpleType(type.getType()) && !type.isCollectionLike() && !this.conversions.hasCustomWriteTarget(type.getType());
    }

    private ElasticsearchPersistentEntity<?> computeClosestEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        TypeInformation typeToUse = this.typeMapper.readType(source);
        if (typeToUse == null) {
            return entity;
        }
        if (!(entity.getTypeInformation().getType().isInterface() || entity.getTypeInformation().isCollectionLike() || entity.getTypeInformation().isMap() || ClassUtils.isAssignableValue((Class)entity.getType(), (Object)typeToUse.getType()))) {
            return entity;
        }
        return (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
    }

    private ElasticsearchPersistentEntity<?> computeGenericValueTypeForRead(ElasticsearchPersistentProperty property, Object value) {
        return ClassTypeInformation.OBJECT.equals((Object)property.getTypeInformation().getActualType()) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property.getTypeInformation().getActualType());
    }

    private Collection<Object> createCollectionForValue(TypeInformation<?> collectionTypeInformation, int size) {
        Class collectionType = collectionTypeInformation.isSubTypeOf(Collection.class) ? collectionTypeInformation.getType() : List.class;
        ClassTypeInformation componentType = collectionTypeInformation.getComponentType() != null ? collectionTypeInformation.getComponentType() : ClassTypeInformation.OBJECT;
        return collectionTypeInformation.getType().isArray() ? new ArrayList(size) : CollectionFactory.createCollection((Class)collectionType, (Class)componentType.getType(), (int)size);
    }

    private boolean isSimpleType(Object value) {
        return this.isSimpleType(value.getClass());
    }

    private boolean isSimpleType(Class<?> type) {
        return this.conversions.isSimpleType(type);
    }

    static class MapValueAccessor {
        final Map<String, Object> target;

        MapValueAccessor(Map<String, Object> target) {
            this.target = target;
        }

        public Object get(ElasticsearchPersistentProperty property) {
            String fieldName = property.getFieldName();
            if (!fieldName.contains(".")) {
                return this.target.get(fieldName);
            }
            Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
            Map<String, Object> source = this.target;
            Object result = null;
            while (source != null && parts.hasNext()) {
                result = source.get(parts.next());
                if (!parts.hasNext()) continue;
                source = this.getAsMap(result);
            }
            return result;
        }

        private Map<String, Object> getAsMap(Object result) {
            if (result instanceof Map) {
                return (Map)result;
            }
            throw new IllegalArgumentException(String.format("%s is not a Map.", result));
        }
    }

    class ElasticsearchPropertyValueProvider
    implements PropertyValueProvider<ElasticsearchPersistentProperty> {
        final MapValueAccessor mapValueAccessor;

        public <T> T getPropertyValue(ElasticsearchPersistentProperty property) {
            return (T)ElasticsearchEntityMapper.this.readValue(this.mapValueAccessor.get(property), property, property.getTypeInformation());
        }

        public ElasticsearchPropertyValueProvider(MapValueAccessor mapValueAccessor) {
            this.mapValueAccessor = mapValueAccessor;
        }
    }
}

