/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public interface ElasticsearchConverter {
    public MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext();

    public ConversionService getConversionService();

    default public String convertId(Object idValue) {
        Assert.notNull((Object)idValue, (String)"idValue must not be null!");
        if (!this.getConversionService().canConvert(idValue.getClass(), String.class)) {
            return idValue.toString();
        }
        return (String)this.getConversionService().convert(idValue, String.class);
    }
}

