/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.util.Assert;

public class MappingElasticsearchEntityInformation<T, ID extends Serializable>
extends PersistentEntityInformation<T, ID>
implements ElasticsearchEntityInformation<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(MappingElasticsearchEntityInformation.class);
    private final ElasticsearchPersistentEntity<T> entityMetadata;
    private final String indexName;
    private final String type;

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity) {
        this(entity, null, null);
    }

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity, String indexName, String type) {
        super(entity);
        this.entityMetadata = entity;
        this.indexName = indexName;
        this.type = type;
    }

    @Override
    public String getIdAttribute() {
        Assert.notNull((Object)this.entityMetadata.getIdProperty(), (String)("Unable to identify 'id' property in class " + this.entityMetadata.getType().getSimpleName() + ". Make sure the 'id' property is annotated with @Id or named as 'id' or 'documentId' "));
        return ((ElasticsearchPersistentProperty)this.entityMetadata.getIdProperty()).getFieldName();
    }

    @Override
    public String getIndexName() {
        return this.indexName != null ? this.indexName : this.entityMetadata.getIndexName();
    }

    @Override
    public String getType() {
        return this.type != null ? this.type : this.entityMetadata.getIndexType();
    }

    @Override
    public Long getVersion(T entity) {
        ElasticsearchPersistentProperty versionProperty = this.entityMetadata.getVersionProperty();
        try {
            if (versionProperty != null) {
                return (Long)this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load version field", e);
        }
        return null;
    }

    @Override
    public String getParentId(T entity) {
        ElasticsearchPersistentProperty parentProperty = this.entityMetadata.getParentIdProperty();
        try {
            if (parentProperty != null) {
                return (String)this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)parentProperty);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load parent ID: " + e, e);
        }
        return null;
    }
}

