/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.histogram.HistogramFacetBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.util.Assert;

public class HistogramFacetRequest
extends AbstractFacetRequest {
    private String field;
    private long interval;
    private TimeUnit timeUnit;

    public HistogramFacetRequest(String name) {
        super(name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public FacetBuilder getFacet() {
        Assert.notNull((Object)this.getName(), (String)"Facet name can't be a null !!!");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)this.field), (String)"Please select field on which to build the facet !!!");
        Assert.isTrue((this.interval > 0L ? 1 : 0) != 0, (String)"Please provide interval as positive value greater them zero !!!");
        HistogramFacetBuilder builder = FacetBuilders.histogramFacet((String)this.getName());
        builder.field(this.field);
        if (this.timeUnit != null) {
            builder.interval(this.interval, this.timeUnit);
        } else {
            builder.interval(this.interval);
        }
        return builder;
    }
}

