/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonValue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.PartTreeN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlQueryCreatorUtils;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlMutateQueryCreator
extends AbstractQueryCreator<N1QLExpression, N1QLExpression>
implements PartTreeN1qlQueryCreator {
    private final N1QLExpression mutateFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;
    private final JsonArray placeHolderValues;
    private final AtomicInteger position;

    public N1qlMutateQueryCreator(PartTree tree, ParameterAccessor parameters, N1QLExpression mutateFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.mutateFrom = mutateFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
        this.placeHolderValues = JsonArray.create();
        this.position = new AtomicInteger(1);
    }

    protected N1QLExpression create(Part part, Iterator<Object> iterator) {
        return N1qlQueryCreatorUtils.prepareExpression(this.converter, part, iterator, this.position, this.placeHolderValues);
    }

    protected N1QLExpression and(Part part, N1QLExpression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        return base.and((N1QLExpression)this.create(part, (Iterator)iterator));
    }

    protected N1QLExpression or(N1QLExpression base, N1QLExpression criteria) {
        return base.or(criteria);
    }

    protected N1QLExpression complete(N1QLExpression criteria, Sort sort) {
        N1QLExpression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        if (whereCriteria == null) {
            return this.mutateFrom;
        }
        return this.mutateFrom.where(whereCriteria);
    }

    @Override
    public JsonValue getPlaceHolderValues() {
        return this.placeHolderValues;
    }
}

