/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.couchbase.core.convert.ConverterHasNoConversion;
import org.springframework.data.mapping.PersistentProperty;

public class JsonValueConverter
implements PropertyValueConverter<Object, Object, ValueConversionContext<? extends PersistentProperty<?>>> {
    protected static final Map<Class<?>, Method> valueMethodCache = new ConcurrentHashMap();
    protected static final Map<Class<?>, Constructor<?>> creatorMethodCache = new ConcurrentHashMap();
    private static final ConverterHasNoConversion CONVERTER_HAS_NO_CONVERSION = new ConverterHasNoConversion();

    public Object read(Object value, ValueConversionContext<? extends PersistentProperty<?>> context) {
        Class type = context.getProperty().getType();
        if (this.getJsonCreatorMethod(type) != null) {
            try {
                return this.getJsonCreatorMethod(type).newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw CONVERTER_HAS_NO_CONVERSION;
    }

    public Object write(Object value, ValueConversionContext<? extends PersistentProperty<?>> context) {
        Class<?> type = value.getClass();
        try {
            return this.getJsonValueMethod(type).invoke(value, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getJsonValueMethod(Class<?> type) {
        return valueMethodCache.get(type);
    }

    private Constructor<?> getJsonCreatorMethod(Class<?> type) {
        return creatorMethodCache.get(type);
    }
}

