/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.couchbase.document;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.SimpleQuery;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.couchbase.document.CouchbaseDocumentSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;

public abstract class AbstractCouchbaseQueryDSL<Q extends AbstractCouchbaseQueryDSL<Q>>
implements SimpleQuery<Q> {
    private final CouchbaseDocumentSerializer serializer;
    private final QueryMixin<Q> queryMixin;

    public AbstractCouchbaseQueryDSL(CouchbaseDocumentSerializer serializer) {
        this.serializer = serializer;
        AbstractCouchbaseQueryDSL query = this;
        this.queryMixin = new QueryMixin((Object)query, (QueryMetadata)new DefaultQueryMetadata(), false);
    }

    protected QueryCriteriaDefinition createCriteria(Predicate predicate) {
        return predicate != null ? (QueryCriteriaDefinition)this.serializer.handle((Expression<?>)predicate) : null;
    }

    @Nullable
    protected Predicate createFilter(QueryMetadata metadata) {
        Predicate filter = !metadata.getJoins().isEmpty() ? ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), this.createJoinFilter(metadata)}) : metadata.getWhere();
        return filter;
    }

    @Nullable
    protected Predicate createJoinFilter(QueryMetadata metadata) {
        HashMap<Path, Predicate> predicates = new HashMap<Path, Predicate>();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Predicate extraFilters = (Predicate)predicates.get(target.getRoot());
            Predicate filter = ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), extraFilters});
            List<Object> ids = this.getIds(target.getType(), filter);
            if (ids.isEmpty()) {
                throw new NoResults();
            }
            Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
            predicates.merge(source.getRoot(), ExpressionUtils.in((Expression)path, ids), ExpressionUtils::and);
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return (Predicate)predicates.get(source.getRoot());
    }

    private Predicate allOf(Collection<Predicate> predicates) {
        return predicates != null ? ExpressionUtils.allOf(predicates) : null;
    }

    protected abstract List<Object> getIds(Class<?> var1, Predicate var2);

    public Q distinct() {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.distinct());
    }

    public Q where(Predicate e) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.where(e));
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.where(e));
    }

    public Q limit(long limit) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.limit(limit));
    }

    public Q offset(long offset) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.offset(offset));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.restrict(modifiers));
    }

    public Q orderBy(OrderSpecifier<?> o) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.orderBy(o));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.orderBy(o));
    }

    public <T> Q set(ParamExpression<T> param, T value) {
        return (Q)((AbstractCouchbaseQueryDSL)this.queryMixin.set(param, value));
    }

    protected Map<String, String> createProjection(Expression<?> projection) {
        if (projection instanceof FactoryExpression) {
            HashMap<String, String> obj = new HashMap<String, String>();
            for (Object expr : ((FactoryExpression)projection).getArgs()) {
                if (!(expr instanceof Expression)) continue;
                obj.put(expr.toString(), (String)this.serializer.handle((Expression)expr));
            }
            return obj;
        }
        return null;
    }

    protected CouchbaseDocument createQuery(@Nullable Predicate predicate) {
        return predicate != null ? (CouchbaseDocument)this.serializer.handle((Expression<?>)predicate) : new CouchbaseDocument();
    }

    protected QueryMixin<Q> getQueryMixin() {
        return this.queryMixin;
    }

    protected CouchbaseDocumentSerializer getSerializer() {
        return this.serializer;
    }

    public CouchbaseDocument asDocument() {
        return this.createQuery(this.queryMixin.getMetadata().getWhere());
    }

    public String toString() {
        return this.asDocument().toString();
    }

    static class NoResults
    extends RuntimeException {
        NoResults() {
        }
    }
}

