/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQueryBase;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryExecution;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ResultProcessingConverter;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractCouchbaseQuery
extends AbstractCouchbaseQueryBase<CouchbaseOperations>
implements RepositoryQuery {
    private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> findOperationWithProjection;

    public AbstractCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)((Object)method), (String)"CouchbaseQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getJavaType();
        ExecutableFindByQueryOperation.ExecutableFindByQuery findOp = operations.findByQuery(type);
        this.findOperationWithProjection = findOp = (ExecutableFindByQueryOperation.ExecutableFindByQuery)findOp.inScope(method.getScope()).inCollection(method.getCollection());
    }

    @Override
    protected Object doExecute(CouchbaseQueryMethod method, ResultProcessor processor, ParametersParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        query = this.applyQueryMetaAttributesIfPresent(query, typeToRead);
        ExecutableFindByQueryOperation.ExecutableFindByQuery<?> find = this.findOperationWithProjection;
        CouchbaseQueryExecution execution = this.getExecution((ParameterAccessor)accessor, new ResultProcessingConverter(processor, this.getOperations(), this.getInstantiators()), find);
        return execution.execute(query, processor.getReturnedType().getDomainType(), typeToRead, null);
    }

    private CouchbaseQueryExecution getExecution(ParameterAccessor accessor, Converter<Object, Object> resultProcessing, ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation) {
        return new CouchbaseQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private CouchbaseQueryExecution getExecutionToWrap(ParameterAccessor accessor, ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new CouchbaseQueryExecution.DeleteExecution((CouchbaseOperations)this.getOperations(), this.getQueryMethod());
        }
        if (this.isTailable(this.getQueryMethod())) {
            return (q, t, r, c) -> operation.as(r).matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return (q, t, r, c) -> operation.as(r).matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isStreamQuery()) {
            return (q, t, r, c) -> operation.as(r).matching(q.with(accessor.getPageable())).stream();
        }
        if (this.isCountQuery()) {
            return (q, t, r, c) -> operation.as(r).matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, r, c) -> operation.as(r).matching(q).exists();
        }
        if (this.getQueryMethod().isPageQuery()) {
            return new CouchbaseQueryExecution.PagedExecution(operation, accessor.getPageable());
        }
        return (q, t, r, c) -> {
            Object find = operation.as(r).matching(q);
            if (this.isCountQuery()) {
                return find.count();
            }
            return this.isLimiting() ? find.first() : find.one();
        };
    }
}

