/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;

public class N1QLQuery
extends Query {
    private N1QLExpression expression;
    private QueryOptions options;

    public N1QLQuery(N1QLExpression expression, QueryOptions options) {
        this.expression = expression;
        this.options = options;
    }

    public N1QLQuery(N1QLExpression expression) {
        this(expression, QueryOptions.queryOptions());
    }

    public String getExpression() {
        return this.expression.toString();
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public JsonObject n1ql() {
        JsonObject query = JsonObject.create().put("statement", this.expression.toString());
        this.options.build().injectParams(query);
        return query;
    }

    @Override
    public String toN1qlSelectString(ReactiveCouchbaseTemplate template, String collectionName, Class domainClass, Class returnClass, boolean isCount, String[] distinctFields, String[] fields) {
        return this.expression.toString();
    }
}

