/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Meta {
    private final Map<String, Object> values = new LinkedHashMap<String, Object>(2);

    public Meta() {
    }

    Meta(Meta source) {
        this.values.putAll(source.values);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public Iterable<Map.Entry<String, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    void setValue(String key, @Nullable Object value) {
        Assert.hasText((String)key, (String)"Meta key must not be 'null' or blank.");
        if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.values.remove(key);
        }
        this.values.put(key, value);
    }

    @Nullable
    private <T> T getValue(String key) {
        return (T)this.values.get(key);
    }

    private <T> T getValue(String key, T defaultValue) {
        T value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public int hashCode() {
        int hash = ObjectUtils.nullSafeHashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)obj;
        return ObjectUtils.nullSafeEquals(this.values, other.values);
    }

    private static enum MetaKey {
        EXAMPLE("$example");

        private String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }
}

