/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByIdOperationSupport
implements ReactiveFindByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindByIdOperationSupport.class);

    ReactiveFindByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByIdOperation.ReactiveFindById<T> findById(Class<T> domainType) {
        return new ReactiveFindByIdSupport<T>(this.template, domainType, null, null, null, null, this.template.support());
    }

    static class ReactiveFindByIdSupport<T>
    implements ReactiveFindByIdOperation.ReactiveFindById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final GetOptions options;
        private final List<String> fields;
        private final ReactiveTemplateSupport support;

        ReactiveFindByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, GetOptions options, List<String> fields, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.fields = fields;
            this.support = support;
        }

        @Override
        public Mono<T> one(String id) {
            return Mono.just((Object)id).flatMap(docId -> {
                GetOptions gOptions;
                GetOptions getOptions = gOptions = this.options != null ? this.options : GetOptions.getOptions();
                if (gOptions.build().transcoder() == null) {
                    gOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
                }
                if (this.fields != null && !this.fields.isEmpty()) {
                    gOptions.project(this.fields);
                }
                PseudoArgs<GetOptions> pArgs = new PseudoArgs<GetOptions>(this.template, this.scope, this.collection, gOptions);
                LOG.trace("statement: {} scope: {} collection: {}", new Object[]{"findById", pArgs.getScope(), pArgs.getCollection()});
                return this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().get(docId, pArgs.getOptions());
            }).flatMap(result -> this.support.decodeEntity(id, (String)result.contentAs(String.class), result.cas(), this.domainType)).onErrorResume(throwable -> {
                if (throwable instanceof RuntimeException && throwable instanceof DocumentNotFoundException) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)throwable);
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        @Override
        public ReactiveFindByIdOperation.TerminatingFindById<T> withOptions(GetOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.fields, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdWithOptions<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, collection, this.options, this.fields, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdInCollection<T> inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, scope, this.collection, this.options, this.fields, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdInScope<T> project(String ... fields) {
            Assert.notEmpty((Object[])fields, (String)"Fields must not be null nor empty.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, Arrays.asList(fields), this.support);
        }
    }
}

