/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperation;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ReactiveExistsByIdOperationSupport
implements ReactiveExistsByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveExistsByIdOperationSupport.class);

    ReactiveExistsByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ReactiveExistsByIdOperation.ReactiveExistsById existsById() {
        return new ReactiveExistsByIdSupport(this.template, null, null, null);
    }

    static class ReactiveExistsByIdSupport
    implements ReactiveExistsByIdOperation.ReactiveExistsById {
        private final ReactiveCouchbaseTemplate template;
        private final String scope;
        private final String collection;
        private final ExistsOptions options;

        ReactiveExistsByIdSupport(ReactiveCouchbaseTemplate template, String scope, String collection, ExistsOptions options) {
            this.template = template;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public Mono<Boolean> one(String id) {
            PseudoArgs<ExistsOptions> pArgs = new PseudoArgs<ExistsOptions>(this.template, this.scope, this.collection, this.options != null ? this.options : ExistsOptions.existsOptions());
            LOG.trace("statement: {} scope: {} collection: {}", new Object[]{"exitsById", pArgs.getScope(), pArgs.getCollection()});
            return Mono.just((Object)id).flatMap(docId -> this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().exists(id, (ExistsOptions)pArgs.getOptions()).map(ExistsResult::exists)).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Mono<Map<String, Boolean>> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(id -> this.one((String)id).map(result -> Tuples.of((Object)id, (Object)result))).collectMap(Tuple2::getT1, Tuple2::getT2);
        }

        @Override
        public ReactiveExistsByIdOperation.ExistsByIdWithOptions inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveExistsByIdSupport(this.template, this.scope, collection, this.options);
        }

        @Override
        public ReactiveExistsByIdOperation.TerminatingExistsById withOptions(ExistsOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveExistsByIdSupport(this.template, this.scope, this.collection, options);
        }

        @Override
        public ReactiveExistsByIdOperation.ExistsByIdInCollection inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveExistsByIdSupport(this.template, scope, this.collection, this.options);
        }
    }
}

