/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.Query;

public class ExecutableRemoveByQueryOperationSupport
implements ExecutableRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableRemoveByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ExecutableRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED);
    }

    static class ExecutableRemoveByQuerySupport<T>
    implements ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;

        ExecutableRemoveByQuerySupport(CouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.reactiveSupport = new ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T>(template.reactive(), domainType, query, scanConsistency);
            this.scanConsistency = scanConsistency;
        }

        @Override
        public List<RemoveResult> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryWithQuery<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }
    }
}

