/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.couchbase.client.java.repository.annotation.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.couchbase.core.convert.AbstractCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.CouchbaseDocumentPropertyAccessor;
import org.springframework.data.couchbase.core.convert.CouchbaseTypeMapper;
import org.springframework.data.couchbase.core.convert.DefaultCouchbaseTypeMapper;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.id.GeneratedValue;
import org.springframework.data.couchbase.core.mapping.id.GenerationStrategy;
import org.springframework.data.couchbase.core.mapping.id.IdAttribute;
import org.springframework.data.couchbase.core.mapping.id.IdPrefix;
import org.springframework.data.couchbase.core.mapping.id.IdSuffix;
import org.springframework.data.couchbase.core.query.N1qlJoin;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingCouchbaseConverter
extends AbstractCouchbaseConverter
implements ApplicationContextAware {
    public static final String TYPEKEY_DEFAULT = "_class";
    public static final String TYPEKEY_SYNCGATEWAY_COMPATIBLE = "javaClass";
    protected ApplicationContext applicationContext;
    protected final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    protected CouchbaseTypeMapper typeMapper;
    private final SpELContext spELContext;
    private boolean enableStrictFieldChecking = false;

    public MappingCouchbaseConverter(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        this(mappingContext, TYPEKEY_DEFAULT);
    }

    public MappingCouchbaseConverter(MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext, String typeKey) {
        super((GenericConversionService)new DefaultConversionService());
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultCouchbaseTypeMapper(typeKey != null ? typeKey : TYPEKEY_DEFAULT);
        this.spELContext = new SpELContext((PropertyAccessor)CouchbaseDocumentPropertyAccessor.INSTANCE);
    }

    public MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public String getTypeKey() {
        return this.typeMapper.getTypeKey();
    }

    public void setEnableStrictFieldChecking(boolean enableStrictFieldChecking) {
        this.enableStrictFieldChecking = enableStrictFieldChecking;
    }

    public <R> R read(Class<R> clazz, CouchbaseDocument source) {
        return this.read((TypeInformation<R>)ClassTypeInformation.from(clazz), source, (Object)null);
    }

    protected <R> R read(TypeInformation<R> type, CouchbaseDocument source) {
        return this.read(type, source, null);
    }

    protected <R> R read(TypeInformation<R> type, CouchbaseDocument source, Object parent) {
        if (source == null) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(source, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), rawType)) {
            return (R)this.conversionService.convert((Object)source, rawType);
        }
        if (typeToUse.isMap()) {
            return (R)this.readMap(typeToUse, source, parent);
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        return this.read(entity, source, parent);
    }

    private boolean isIdConstructionProperty(CouchbasePersistentProperty property) {
        return property.isAnnotationPresent(IdPrefix.class) || property.isAnnotationPresent(IdSuffix.class);
    }

    protected <R> R read(final CouchbasePersistentEntity<R> entity, final CouchbaseDocument source, Object parent) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)source, this.spELContext);
        ParameterValueProvider<CouchbasePersistentProperty> provider = this.getParameterProvider(entity, source, evaluator, parent);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        final Object instance = instantiator.createInstance(entity, provider);
        final ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(instance);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CouchbasePersistentProperty>(){

            public void doWithPersistentProperty(CouchbasePersistentProperty prop) {
                if (!this.doesPropertyExistInSource(prop) || entity.isConstructorArgument(prop) || this.isIdConstructionProperty(prop) || prop.isAnnotationPresent(N1qlJoin.class)) {
                    return;
                }
                String obj = prop.isIdProperty() ? source.getId() : MappingCouchbaseConverter.this.getValueInternal(prop, source, instance);
                accessor.setProperty((PersistentProperty)prop, (Object)obj);
            }

            private boolean doesPropertyExistInSource(CouchbasePersistentProperty property) {
                return property.isIdProperty() || source.containsKey(property.getFieldName());
            }

            private boolean isIdConstructionProperty(CouchbasePersistentProperty property) {
                return property.isAnnotationPresent(IdPrefix.class) || property.isAnnotationPresent(IdSuffix.class);
            }
        });
        entity.doWithAssociations(association -> {
            CouchbasePersistentProperty inverseProp = (CouchbasePersistentProperty)association.getInverse();
            Object obj = this.getValueInternal(inverseProp, source, instance);
            accessor.setProperty((PersistentProperty)inverseProp, obj);
        });
        return (R)instance;
    }

    protected Object getValueInternal(CouchbasePersistentProperty property, CouchbaseDocument source, Object parent) {
        return new CouchbasePropertyValueProvider(source, this.spELContext, parent).getPropertyValue(property);
    }

    private ParameterValueProvider<CouchbasePersistentProperty> getParameterProvider(CouchbasePersistentEntity<?> entity, CouchbaseDocument source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
        CouchbasePropertyValueProvider provider = new CouchbasePropertyValueProvider(source, evaluator, parent);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, parent);
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<CouchbasePersistentProperty>)parameterProvider, parent);
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, CouchbaseDocument source, Object parent) {
        Assert.notNull((Object)source, (String)"CouchbaseDocument must not be null!");
        Class mapType = this.typeMapper.readType(source, type).getType();
        Map map = CollectionFactory.createMap((Class)mapType, (int)source.export().keySet().size());
        HashMap<String, Object> sourceMap = source.getPayload();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            TypeInformation keyTypeInformation = type.getComponentType();
            if (keyTypeInformation != null) {
                Class keyType = keyTypeInformation.getType();
                key = this.conversionService.convert(key, keyType);
            }
            TypeInformation valueType = type.getMapValueType();
            if (value instanceof CouchbaseDocument) {
                map.put(key, this.read(valueType, (CouchbaseDocument)value, parent));
                continue;
            }
            if (value instanceof CouchbaseList) {
                map.put(key, this.readCollection(valueType, (CouchbaseList)value, parent));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        if (Class.class.isAssignableFrom(target)) {
            try {
                return Class.forName(value.toString());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Unable to create class from " + value.toString());
            }
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    public void write(Object source, CouchbaseDocument target) {
        if (source == null) {
            return;
        }
        boolean isCustom = this.conversions.getCustomWriteTarget(source.getClass(), CouchbaseDocument.class).isPresent();
        ClassTypeInformation type = ClassTypeInformation.from(source.getClass());
        if (!isCustom) {
            this.typeMapper.writeType((TypeInformation)type, target);
        }
        this.writeInternal(source, target, (TypeInformation<?>)type);
        if (target.getId() == null) {
            throw new MappingException("An ID property is needed, but not found/could not be generated on this entity.");
        }
    }

    protected void writeInternal(Object source, CouchbaseDocument target, TypeInformation<?> typeHint) {
        if (source == null) {
            return;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(source.getClass(), CouchbaseDocument.class);
        if (customTarget.isPresent()) {
            this.copyCouchbaseDocument((CouchbaseDocument)this.conversionService.convert(source, CouchbaseDocument.class), target);
            return;
        }
        if (Map.class.isAssignableFrom(source.getClass())) {
            this.writeMapInternal((Map)source, target, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(source.getClass())) {
            throw new IllegalArgumentException("Root Document must be either CouchbaseDocument or Map.");
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        this.writeInternal(source, target, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, source, target);
    }

    protected void copyCouchbaseDocument(CouchbaseDocument source, CouchbaseDocument target) {
        for (Map.Entry<String, Object> entry : source.export().entrySet()) {
            target.put(entry.getKey(), entry.getValue());
        }
        target.setId(source.getId());
        target.setExpiration(source.getExpiration());
    }

    private String convertToString(Object propertyObj) {
        if (propertyObj instanceof String) {
            return (String)propertyObj;
        }
        if (propertyObj instanceof Number) {
            return new StringBuffer().append(propertyObj).toString();
        }
        return propertyObj.toString();
    }

    protected void writeInternal(Object source, final CouchbaseDocument target, CouchbasePersistentEntity<?> entity) {
        if (source == null) {
            return;
        }
        if (entity == null) {
            throw new MappingException("No mapping metadata found for entity of type " + source.getClass().getName());
        }
        final ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(source);
        final CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)entity.getIdProperty();
        final CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)entity.getVersionProperty();
        GeneratedValue generatedValueInfo = null;
        final TreeMap<Integer, String> prefixes = new TreeMap<Integer, String>();
        final TreeMap<Integer, String> suffixes = new TreeMap<Integer, String>();
        final TreeMap<Integer, String> idAttributes = new TreeMap<Integer, String>();
        target.setExpiration(entity.getExpiry());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CouchbasePersistentProperty>(){

            public void doWithPersistentProperty(CouchbasePersistentProperty prop) {
                if (prop.equals(idProperty) || versionProperty != null && prop.equals(versionProperty)) {
                    return;
                }
                if (MappingCouchbaseConverter.this.enableStrictFieldChecking && !prop.isAnnotationPresent(Field.class)) {
                    return;
                }
                if (prop.isAnnotationPresent(N1qlJoin.class)) {
                    return;
                }
                Object propertyObj = accessor.getProperty((PersistentProperty)prop, prop.getType());
                if (null != propertyObj) {
                    if (prop.isAnnotationPresent(IdPrefix.class)) {
                        IdPrefix prefix = (IdPrefix)prop.findAnnotation(IdPrefix.class);
                        int order = prefix.order();
                        prefixes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                        return;
                    }
                    if (prop.isAnnotationPresent(IdSuffix.class)) {
                        IdSuffix suffix = (IdSuffix)prop.findAnnotation(IdSuffix.class);
                        int order = suffix.order();
                        suffixes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                        return;
                    }
                    if (prop.isAnnotationPresent(IdAttribute.class)) {
                        IdAttribute idAttribute = (IdAttribute)prop.findAnnotation(IdAttribute.class);
                        int order = idAttribute.order();
                        idAttributes.put(order, MappingCouchbaseConverter.this.convertToString(propertyObj));
                    }
                    if (!MappingCouchbaseConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingCouchbaseConverter.this.writePropertyInternal(propertyObj, target, prop);
                    } else {
                        MappingCouchbaseConverter.this.writeSimpleInternal(propertyObj, target, prop.getFieldName());
                    }
                }
            }
        });
        if (idProperty != null && target.getId() == null) {
            String id = (String)accessor.getProperty((PersistentProperty)idProperty, String.class);
            if (idProperty.isAnnotationPresent(GeneratedValue.class) && (id == null || id.equals(""))) {
                generatedValueInfo = (GeneratedValue)idProperty.findAnnotation(GeneratedValue.class);
                target.setId(this.generateId(generatedValueInfo, prefixes, suffixes, idAttributes));
            } else {
                target.setId(id);
            }
        }
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<CouchbasePersistentProperty>(){

            public void doWithAssociation(Association<CouchbasePersistentProperty> association) {
                Class type;
                CouchbasePersistentProperty inverseProp = (CouchbasePersistentProperty)association.getInverse();
                Object propertyObj = accessor.getProperty((PersistentProperty)inverseProp, type = inverseProp.getType());
                if (null != propertyObj) {
                    MappingCouchbaseConverter.this.writePropertyInternal(propertyObj, target, inverseProp);
                }
            }
        });
    }

    private void writePropertyInternal(Object source, CouchbaseDocument target, CouchbasePersistentProperty prop) {
        if (source == null) {
            return;
        }
        String name = prop.getFieldName();
        ClassTypeInformation valueType = ClassTypeInformation.from(source.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            CouchbaseList collectionDoc = this.createCollection(MappingCouchbaseConverter.asCollection(source), prop);
            target.put(name, collectionDoc);
            return;
        }
        if (valueType.isMap()) {
            CouchbaseDocument mapDoc = this.createMap((Map)source, prop);
            target.put(name, mapDoc);
            return;
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(source.getClass());
        if (basicTargetType.isPresent()) {
            basicTargetType.ifPresent(it -> target.put(name, this.conversionService.convert(source, it)));
            return;
        }
        CouchbaseDocument propertyDoc = new CouchbaseDocument();
        this.addCustomTypeKeyIfNecessary(type, source, propertyDoc);
        CouchbasePersistentEntity entity = MappingCouchbaseConverter.isSubtype(prop.getType(), source.getClass()) ? (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass()) : (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        this.writeInternal(source, propertyDoc, entity);
        target.put(name, propertyDoc);
    }

    private CouchbaseDocument createMap(Map<Object, Object> map, CouchbasePersistentProperty prop) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)prop, (String)"PersistentProperty must not be null!");
        return this.writeMapInternal(map, new CouchbaseDocument(), prop.getTypeInformation());
    }

    private CouchbaseDocument writeMapInternal(Map<Object, Object> source, CouchbaseDocument target, TypeInformation<?> type) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = key.toString();
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, target, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    target.put(simpleKey, this.writeCollectionInternal(MappingCouchbaseConverter.asCollection(val), new CouchbaseList(this.conversions.getSimpleTypeHolder()), type.getMapValueType()));
                    continue;
                }
                CouchbaseDocument embeddedDoc = new CouchbaseDocument();
                ClassTypeInformation valueTypeInfo = type.isMap() ? type.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, embeddedDoc, (TypeInformation<?>)valueTypeInfo);
                target.put(simpleKey, embeddedDoc);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return target;
    }

    private CouchbaseList createCollection(Collection<?> collection, CouchbasePersistentProperty prop) {
        return this.writeCollectionInternal(collection, new CouchbaseList(this.conversions.getSimpleTypeHolder()), prop.getTypeInformation());
    }

    private CouchbaseList writeCollectionInternal(Collection<?> source, CouchbaseList target, TypeInformation<?> type) {
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                target.put(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                target.put(this.writeCollectionInternal(MappingCouchbaseConverter.asCollection(element), new CouchbaseList(this.conversions.getSimpleTypeHolder()), componentType));
                continue;
            }
            CouchbaseDocument embeddedDoc = new CouchbaseDocument();
            this.writeInternal(element, embeddedDoc, componentType);
            target.put(embeddedDoc);
        }
        return target;
    }

    private Object readCollection(TypeInformation<?> targetType, CouchbaseList source, Object parent) {
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class<List> collectionType = targetType.getType();
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(new HashSet(), collectionType);
        }
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        ArrayList<Object> items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (int)source.size(false));
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType == null ? null : componentType.getType();
        for (int i = 0; i < source.size(false); ++i) {
            Object dbObjItem = source.get(i);
            if (dbObjItem instanceof CouchbaseDocument) {
                items.add(this.read(componentType, (CouchbaseDocument)dbObjItem, parent));
                continue;
            }
            if (dbObjItem instanceof CouchbaseList) {
                items.add(this.readCollection(componentType, (CouchbaseList)dbObjItem, parent));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private static boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private void writeSimpleInternal(Object source, CouchbaseDocument target, String key) {
        target.put(key, this.getPotentiallyConvertedSimpleWrite(source));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        return customTarget.map(it -> this.conversionService.convert(value, it)).orElseGet(() -> Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value);
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object source, CouchbaseDocument target) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : type;
        Class reference = actualType == null ? Object.class : actualType.getType();
        boolean bl = notTheSameClass = !source.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(source.getClass(), target);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private <R> R readValue(Object value, TypeInformation<?> type, Object parent) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (R)this.conversionService.convert(value, rawType);
        }
        if (value instanceof CouchbaseDocument) {
            return (R)this.read(type, (CouchbaseDocument)value, parent);
        }
        if (value instanceof CouchbaseList) {
            return (R)this.readCollection(type, (CouchbaseList)value, parent);
        }
        return (R)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    private ConvertingPropertyAccessor<Object> getPropertyAccessor(Object source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    private String generateId(GeneratedValue generatedValue, TreeMap<Integer, String> prefixes, TreeMap<Integer, String> suffixes, TreeMap<Integer, String> idAttributes) {
        String delimiter = generatedValue.delimiter();
        StringBuilder sb = new StringBuilder();
        boolean isAppending = false;
        if (prefixes.size() > 0) {
            this.appendKeyParts(sb, prefixes.values(), delimiter);
            isAppending = true;
        }
        if (generatedValue.strategy() == GenerationStrategy.USE_ATTRIBUTES && idAttributes.size() > 0) {
            if (isAppending) {
                sb.append(delimiter);
            }
            this.appendKeyParts(sb, idAttributes.values(), delimiter);
        }
        if (generatedValue.strategy() == GenerationStrategy.UNIQUE) {
            if (isAppending) {
                sb.append(delimiter);
            }
            sb.append(UUID.randomUUID());
        }
        if (suffixes.size() > 0) {
            if (isAppending) {
                sb.append(delimiter);
            }
            this.appendKeyParts(sb, suffixes.values(), delimiter);
        }
        return sb.toString();
    }

    private StringBuilder appendKeyParts(StringBuilder sb, Collection<String> values, String delimiter) {
        boolean isAppending = false;
        for (String value : values) {
            if (isAppending) {
                sb.append(delimiter);
            } else {
                isAppending = true;
            }
            sb.append(value);
        }
        return sb;
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<CouchbasePersistentProperty> {
        private final Object parent;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<CouchbasePersistentProperty> delegate, Object parent) {
            super(evaluator, conversionService, delegate);
            this.parent = parent;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, CouchbasePersistentProperty> parameter) {
            return (T)MappingCouchbaseConverter.this.readValue(object, parameter.getType(), this.parent);
        }
    }

    private class CouchbasePropertyValueProvider
    implements PropertyValueProvider<CouchbasePersistentProperty> {
        private final CouchbaseDocument source;
        private final SpELExpressionEvaluator evaluator;
        private final Object parent;

        public CouchbasePropertyValueProvider(CouchbaseDocument source, SpELContext factory, Object parent) {
            this(source, new DefaultSpELExpressionEvaluator((Object)source, factory), parent);
        }

        public CouchbasePropertyValueProvider(CouchbaseDocument source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
            Assert.notNull((Object)source, (String)"CouchbaseDocument must not be null!");
            Assert.notNull((Object)evaluator, (String)"DefaultSpELExpressionEvaluator must not be null!");
            this.source = source;
            this.evaluator = evaluator;
            this.parent = parent;
        }

        public <R> R getPropertyValue(CouchbasePersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(property.getFieldName());
            if (property.isIdProperty()) {
                return (R)this.source.getId();
            }
            if (value == null) {
                return null;
            }
            return (R)MappingCouchbaseConverter.this.readValue(value, property.getTypeInformation(), this.parent);
        }
    }
}

