/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.view.SpatialViewQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseParameterAccessor;
import org.springframework.data.couchbase.repository.query.SpatialViewQueryCreator;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import reactor.core.publisher.Flux;

public class ReactiveSpatialViewBasedQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveSpatialViewBasedQuery.class);
    private final CouchbaseQueryMethod method;
    private final RxJavaCouchbaseOperations operations;

    public ReactiveSpatialViewBasedQuery(CouchbaseQueryMethod method, RxJavaCouchbaseOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] runtimeParams) {
        String designDoc = this.method.getDimensionalAnnotation().designDocument();
        String viewName = this.method.getDimensionalAnnotation().spatialViewName();
        int dimensions = this.method.getDimensionalAnnotation().dimensions();
        PartTree tree = new PartTree(this.method.getName(), this.method.getEntityInformation().getJavaType());
        SpatialViewQuery baseSpatialQuery = SpatialViewQuery.from((String)designDoc, (String)viewName).stale(this.operations.getDefaultConsistency().viewConsistency());
        SpatialViewQueryCreator creator = new SpatialViewQueryCreator(dimensions, tree, (ParameterAccessor)new ReactiveCouchbaseParameterAccessor(this.method, runtimeParams), baseSpatialQuery, this.operations.getConverter());
        SpatialViewQueryCreator.SpatialViewQueryWrapper finalQuery = (SpatialViewQueryCreator.SpatialViewQueryWrapper)creator.createQuery();
        return this.execute(finalQuery);
    }

    protected Object execute(SpatialViewQueryCreator.SpatialViewQueryWrapper query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing spatial view query: " + query.getQuery().toString());
        }
        return ReactiveWrapperConverters.toWrapper(this.operations.findBySpatialView(query.getQuery(), this.method.getEntityInformation().getJavaType()), Flux.class);
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.method;
    }
}

