/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseSimpleTypes;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CouchbaseList
implements CouchbaseStorable {
    private List<Object> payload;
    private SimpleTypeHolder simpleTypeHolder;

    public CouchbaseList() {
        this(new ArrayList<Object>());
    }

    public CouchbaseList(List<Object> initialPayload) {
        this(initialPayload, null);
    }

    public CouchbaseList(SimpleTypeHolder simpleTypeHolder) {
        this(new ArrayList<Object>(), simpleTypeHolder);
    }

    public CouchbaseList(List<Object> initialPayload, SimpleTypeHolder simpleTypeHolder) {
        this.payload = initialPayload;
        if (simpleTypeHolder != null) {
            HashSet<Class> additionalTypes = new HashSet<Class>();
            additionalTypes.add(CouchbaseDocument.class);
            additionalTypes.add(CouchbaseList.class);
            this.simpleTypeHolder = new SimpleTypeHolder(additionalTypes, simpleTypeHolder);
        } else {
            this.simpleTypeHolder = CouchbaseSimpleTypes.DOCUMENT_TYPES;
        }
    }

    public final CouchbaseList put(Object value) {
        this.verifyValueType(value);
        this.payload.add(value);
        return this;
    }

    public final Object get(int index) {
        return this.payload.get(index);
    }

    public final int size() {
        return this.size(false);
    }

    public final int size(boolean recursive) {
        int thisSize = this.payload.size();
        if (!recursive || thisSize == 0) {
            return thisSize;
        }
        int totalSize = thisSize;
        for (Object value : this.payload) {
            if (value instanceof CouchbaseDocument) {
                totalSize += ((CouchbaseDocument)value).size(true);
                continue;
            }
            if (!(value instanceof CouchbaseList)) continue;
            totalSize += ((CouchbaseList)value).size(true);
        }
        return totalSize;
    }

    public final List<Object> export() {
        ArrayList<Object> toExport = new ArrayList<Object>(this.payload);
        int elem = 0;
        for (Object entry : this.payload) {
            if (entry instanceof CouchbaseDocument) {
                toExport.remove(elem);
                toExport.add(elem, ((CouchbaseDocument)entry).export());
            } else if (entry instanceof CouchbaseList) {
                toExport.remove(elem);
                toExport.add(elem, ((CouchbaseList)entry).export());
            }
            ++elem;
        }
        return toExport;
    }

    public final boolean containsValue(Object value) {
        return this.payload.contains(value);
    }

    public final boolean isEmpty() {
        return this.payload.isEmpty();
    }

    private void verifyValueType(Object value) {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (this.simpleTypeHolder.isSimpleType(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Attribute of type " + clazz.getCanonicalName() + "can not be stored and must be converted.");
    }

    public String toString() {
        return "CouchbaseList{payload=" + this.payload + '}';
    }
}

