/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.MutateLimitPath;
import com.couchbase.client.java.query.dsl.path.MutateWherePath;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.PartTreeN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlQueryCreatorUtils;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlMutateQueryCreator
extends AbstractQueryCreator<MutateLimitPath, Expression>
implements PartTreeN1qlQueryCreator {
    private final MutateWherePath mutateFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;
    private final JsonArray placeHolderValues;
    private final AtomicInteger position;

    public N1qlMutateQueryCreator(PartTree tree, ParameterAccessor parameters, MutateWherePath mutateFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.mutateFrom = mutateFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
        this.placeHolderValues = JsonArray.create();
        this.position = new AtomicInteger(1);
    }

    protected Expression create(Part part, Iterator<Object> iterator) {
        return N1qlQueryCreatorUtils.prepareExpression(this.converter, part, iterator, this.position, this.placeHolderValues);
    }

    protected Expression and(Part part, Expression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        return base.and(this.create(part, iterator));
    }

    protected Expression or(Expression base, Expression criteria) {
        return base.or(criteria);
    }

    protected MutateLimitPath complete(Expression criteria, Sort sort) {
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        return this.mutateFrom.where(whereCriteria);
    }

    @Override
    public JsonValue getPlaceHolderValues() {
        return this.placeHolderValues;
    }
}

