/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.view.SpatialViewQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.couchbase.repository.query.support.AwtPointInShapeEvaluator;
import org.springframework.data.couchbase.repository.query.support.GeoUtils;
import org.springframework.data.couchbase.repository.query.support.PointInShapeEvaluator;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class SpatialViewQueryCreator
extends AbstractQueryCreator<SpatialViewQueryWrapper, SpatialViewQuery> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialViewQueryCreator.class);
    private final SpatialViewQuery query;
    private final PartTree tree;
    private final CouchbaseConverter converter;
    private final int dimensions;
    private final JsonArray startRange;
    private final JsonArray endRange;
    private final List<AbstractFalsePositiveEvaluator> evaluators;

    public SpatialViewQueryCreator(int dimensions, PartTree tree, ParameterAccessor parameters, SpatialViewQuery query, CouchbaseConverter converter) {
        super(tree, parameters);
        this.query = query;
        this.tree = tree;
        this.converter = converter;
        this.dimensions = dimensions;
        this.startRange = JsonArray.create();
        this.endRange = JsonArray.create();
        this.evaluators = new ArrayList<AbstractFalsePositiveEvaluator>();
    }

    protected SpatialViewQuery create(Part part, Iterator<Object> objectIterator) {
        ConvertingIterator iterator = new ConvertingIterator(objectIterator, this.converter);
        switch (part.getType()) {
            case WITHIN: {
                SpatialViewQueryCreator.applyWithin(this.startRange, this.endRange, iterator, this.evaluators, part.getProperty());
                break;
            }
            case NEAR: {
                SpatialViewQueryCreator.applyNear(this.startRange, this.endRange, iterator, this.evaluators, part.getProperty());
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case AFTER: {
                this.startRange.add(SpatialViewQueryCreator.checkedNext(iterator, Object.class, null));
                this.endRange.addNull();
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case BEFORE: {
                this.startRange.addNull();
                this.endRange.add(SpatialViewQueryCreator.checkedNext(iterator, Object.class, null));
                break;
            }
            case SIMPLE_PROPERTY: {
                Object equals = SpatialViewQueryCreator.checkedNext(iterator, Object.class, null);
                this.startRange.add(equals);
                this.endRange.add(equals);
                break;
            }
            case BETWEEN: {
                this.startRange.add(SpatialViewQueryCreator.checkedNext(iterator, Object.class, null));
                this.endRange.add(SpatialViewQueryCreator.checkedNext(iterator, Object.class, null));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword in Spatial View query derivation: " + part.toString());
            }
        }
        return this.query;
    }

    private static void completeRangeIfNeeded(JsonArray range, int dimensions) {
        for (int i = range.size(); i < dimensions; ++i) {
            range.addNull();
        }
    }

    private static void applyWithin(JsonArray startRange, JsonArray endRange, Iterator<Object> iterator, List<AbstractFalsePositiveEvaluator> evaluators, PropertyPath path) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Not enough parameters for within");
        }
        Object next = iterator.next();
        if (next instanceof Circle) {
            evaluators.add(new CircleFalsePositiveEvaluator(path, (Circle)next));
            GeoUtils.convertShapeTo2DRanges(startRange, endRange, (Shape)((Circle)next));
        } else if (next instanceof Polygon) {
            evaluators.add(new PolygonFalsePositiveEvaluator(path, (Polygon)next));
            GeoUtils.convertShapeTo2DRanges(startRange, endRange, (Shape)((Polygon)next));
        } else if (next instanceof Box) {
            GeoUtils.convertShapeTo2DRanges(startRange, endRange, (Shape)((Box)next));
        } else if (next instanceof Point) {
            Point northwest = (Point)next;
            Point southeast = SpatialViewQueryCreator.checkedNext(iterator, Point.class, "Cannot compute a bounding box for within, 2 Point needed");
            GeoUtils.convertPointsTo2DRanges(startRange, endRange, true, northwest, southeast);
        } else if (next instanceof Point[]) {
            evaluators.add(new PointArrayFalsePositiveEvaluator(path, (Point[])next));
            GeoUtils.convertPointsTo2DRanges(startRange, endRange, false, (Point[])next);
        } else if (next instanceof JsonArray) {
            JsonArray first = (JsonArray)next;
            for (Object o : first) {
                startRange.add(o);
            }
            JsonArray second = SpatialViewQueryCreator.checkedNext(iterator, JsonArray.class, "2 JsonArray required for within: startRange and endRange");
            for (Object o : second) {
                endRange.add(o);
            }
        } else {
            throw new IllegalArgumentException("Unsupported parameter type for within: " + next.getClass());
        }
    }

    private static void applyNear(JsonArray startRange, JsonArray endRange, Iterator<Object> iterator, List<AbstractFalsePositiveEvaluator> evaluators, PropertyPath path) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Not enough parameters for near");
        }
        Point near = SpatialViewQueryCreator.checkedNext(iterator, Point.class, "Near queries need a Point as first argument");
        Distance distance = SpatialViewQueryCreator.checkedNext(iterator, Distance.class, "Near queries need a maximum Distance as second argument");
        evaluators.add(new CircleFalsePositiveEvaluator(path, new Circle(near, distance)));
        double[] boundingBox = GeoUtils.getBoundingBoxForNear(near, distance);
        startRange.add(boundingBox[0]).add(boundingBox[1]);
        endRange.add(boundingBox[2]).add(boundingBox[3]);
    }

    private static <T> T checkedNext(Iterator<?> iterator, Class<T> clazz, String errorMsg) {
        if (errorMsg == null) {
            errorMsg = "Expected an additional parameter of type " + clazz.getName();
        }
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException(errorMsg + ", missing parameter");
        }
        Object next = iterator.next();
        if (clazz.isInstance(next)) {
            return (T)next;
        }
        if (next == null) {
            throw new IllegalArgumentException(errorMsg + ", got null");
        }
        throw new IllegalArgumentException(errorMsg + ", got a " + next.getClass().getName());
    }

    protected SpatialViewQuery and(Part part, SpatialViewQuery base, Iterator<Object> iterator) {
        return this.create(part, iterator);
    }

    protected SpatialViewQuery or(SpatialViewQuery base, SpatialViewQuery criteria) {
        throw new UnsupportedOperationException("Or is not supported for View-based queries");
    }

    protected SpatialViewQueryWrapper complete(SpatialViewQuery criteria, Sort sort) {
        if (sort != null) {
            throw new IllegalArgumentException("Sort is not supported on Spatial View queries");
        }
        if (this.tree.isLimiting()) {
            this.query.limit(this.tree.getMaxResults().intValue());
        }
        if (this.startRange.isEmpty() && this.endRange.isEmpty()) {
            return new SpatialViewQueryWrapper(this.query, this.evaluators);
        }
        SpatialViewQueryCreator.completeRangeIfNeeded(this.startRange, this.dimensions);
        SpatialViewQueryCreator.completeRangeIfNeeded(this.endRange, this.dimensions);
        return new SpatialViewQueryWrapper(this.query.range(this.startRange, this.endRange), this.evaluators);
    }

    public static class SpatialViewQueryWrapper {
        private SpatialViewQuery query;
        private List<AbstractFalsePositiveEvaluator> eliminators;

        public SpatialViewQueryWrapper(SpatialViewQuery query, List<AbstractFalsePositiveEvaluator> eliminators) {
            this.query = query;
            this.eliminators = eliminators;
        }

        public SpatialViewQuery getQuery() {
            return this.query;
        }

        public <T> List<T> eliminate(List<T> objects) {
            ArrayList<T> result = new ArrayList<T>(objects.size());
            for (T object : objects) {
                BeanWrapperImpl bean = new BeanWrapperImpl(object);
                boolean pass = true;
                for (AbstractFalsePositiveEvaluator eliminator : this.eliminators) {
                    pass = pass && eliminator.evaluate(object, (BeanWrapper)bean);
                }
                if (pass) {
                    result.add(object);
                    continue;
                }
                LOGGER.trace("Object {} was a false positive in geo query", object);
            }
            return result;
        }
    }

    public static final class PointArrayFalsePositiveEvaluator
    extends AbstractFalsePositiveEvaluator {
        private final Point[] criteria;

        public PointArrayFalsePositiveEvaluator(PropertyPath path, Point[] criteria) {
            super(path);
            this.criteria = criteria;
        }

        @Override
        protected boolean evaluateCriteria(Point p) {
            return POINT_IN_SHAPE.pointInPolygon(p, this.criteria);
        }
    }

    public static class PolygonFalsePositiveEvaluator
    extends AbstractFalsePositiveEvaluator {
        private final Polygon criteria;

        public PolygonFalsePositiveEvaluator(PropertyPath path, Polygon criteria) {
            super(path);
            this.criteria = criteria;
        }

        @Override
        protected boolean evaluateCriteria(Point p) {
            return POINT_IN_SHAPE.pointInPolygon(p, this.criteria);
        }
    }

    public static class CircleFalsePositiveEvaluator
    extends AbstractFalsePositiveEvaluator {
        private final Circle criteria;

        public CircleFalsePositiveEvaluator(PropertyPath path, Circle criteria) {
            super(path);
            this.criteria = criteria;
        }

        @Override
        protected boolean evaluateCriteria(Point p) {
            return POINT_IN_SHAPE.pointInCircle(p, this.criteria);
        }
    }

    public static abstract class AbstractFalsePositiveEvaluator {
        protected static final PointInShapeEvaluator POINT_IN_SHAPE = new AwtPointInShapeEvaluator();
        protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFalsePositiveEvaluator.class);
        protected final PropertyPath propertyPath;

        protected AbstractFalsePositiveEvaluator(PropertyPath path) {
            this.propertyPath = path;
        }

        public boolean evaluate(Object original, BeanWrapper bean) {
            Object value = bean.getPropertyValue(this.propertyPath.toDotPath());
            if (value instanceof Point) {
                return this.evaluateCriteria((Point)value);
            }
            if (value == null) {
                LOGGER.trace("Cannot find a Point (was null) for attribute {}, object is {}", (Object)this.propertyPath.toDotPath(), original);
                return false;
            }
            LOGGER.trace("Cannot find a Point (was {}) for attribute {}, object is {}", new Object[]{value.getClass().getName(), this.propertyPath.toDotPath(), original});
            return false;
        }

        protected abstract boolean evaluateCriteria(Point var1);
    }
}

