/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public final class DateConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private DateConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        boolean useISOStringConverterForDate = Boolean.parseBoolean(System.getProperty("org.springframework.data.couchbase.useISOStringConverterForDate", "false"));
        if (useISOStringConverterForDate) {
            converters.add(DateToStringConverter.INSTANCE);
        } else {
            converters.add(DateToLongConverter.INSTANCE);
        }
        converters.add(SerializedObjectToDateConverter.INSTANCE);
        converters.add(CalendarToLongConverter.INSTANCE);
        converters.add(NumberToCalendarConverter.INSTANCE);
        if (JODA_TIME_IS_PRESENT) {
            converters.add(LocalDateToLongConverter.INSTANCE);
            converters.add(LocalDateTimeToLongConverter.INSTANCE);
            converters.add(DateTimeToLongConverter.INSTANCE);
            converters.add(DateMidnightToLongConverter.INSTANCE);
            converters.add(NumberToLocalDateConverter.INSTANCE);
            converters.add(NumberToLocalDateTimeConverter.INSTANCE);
            converters.add(NumberToDateTimeConverter.INSTANCE);
            converters.add(NumberToDateMidnightConverter.INSTANCE);
        }
        return converters;
    }

    @ReadingConverter
    public static enum NumberToDateMidnightConverter implements Converter<Number, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(Number source) {
            return source == null ? null : new DateMidnight(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToDateTimeConverter implements Converter<Number, DateTime>
    {
        INSTANCE;


        public DateTime convert(Number source) {
            return source == null ? null : new DateTime(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateTimeConverter implements Converter<Number, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Number source) {
            return source == null ? null : new LocalDateTime(source.longValue());
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateConverter implements Converter<Number, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Number source) {
            return source == null ? null : new LocalDate(source.longValue());
        }
    }

    @WritingConverter
    public static enum DateMidnightToLongConverter implements Converter<DateMidnight, Long>
    {
        INSTANCE;


        public Long convert(DateMidnight source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum DateTimeToLongConverter implements Converter<DateTime, Long>
    {
        INSTANCE;


        public Long convert(DateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToLongConverter implements Converter<LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(LocalDateTime source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @WritingConverter
    public static enum LocalDateToLongConverter implements Converter<LocalDate, Long>
    {
        INSTANCE;


        public Long convert(LocalDate source) {
            return source == null ? null : Long.valueOf(source.toDate().getTime());
        }
    }

    @ReadingConverter
    public static enum NumberToCalendarConverter implements Converter<Number, Calendar>
    {
        INSTANCE;


        public Calendar convert(Number source) {
            if (source == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(source.longValue() * 1000L);
            return calendar;
        }
    }

    @WritingConverter
    public static enum CalendarToLongConverter implements Converter<Calendar, Long>
    {
        INSTANCE;


        public Long convert(Calendar source) {
            return source == null ? null : Long.valueOf(source.getTimeInMillis() / 1000L);
        }
    }

    @WritingConverter
    public static enum DateToLongConverter implements Converter<Date, Long>
    {
        INSTANCE;


        public Long convert(Date source) {
            return source == null ? null : Long.valueOf(source.getTime());
        }
    }

    @ReadingConverter
    public static enum SerializedObjectToDateConverter implements Converter<Object, Date>
    {
        INSTANCE;


        public Date convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                Date date = new Date();
                date.setTime(((Number)source).longValue());
                return date;
            }
            if (source instanceof String) {
                return Date.from(Instant.parse((String)source).atZone(ZoneId.systemDefault()).toInstant());
            }
            return null;
        }
    }

    @WritingConverter
    public static enum DateToStringConverter implements Converter<Date, String>
    {
        INSTANCE;


        public String convert(Date source) {
            return source == null ? null : source.toInstant().toString();
        }
    }
}

