/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.SlicedModel;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.lang.CheckReturnValue;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SlicedResourcesAssembler<T>
implements RepresentationModelAssembler<Slice<T>, SlicedModel<EntityModel<T>>> {
    private final HateoasPageableHandlerMethodArgumentResolver pageableResolver;
    private final @Nullable UriComponents baseUri;
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);
    private boolean forceFirstRel = false;
    private final @Nullable MethodParameter parameter;

    public SlicedResourcesAssembler(@Nullable HateoasPageableHandlerMethodArgumentResolver resolver, @Nullable UriComponents baseUri) {
        this(resolver, baseUri, null);
    }

    private SlicedResourcesAssembler(@Nullable HateoasPageableHandlerMethodArgumentResolver resolver, @Nullable UriComponents baseUri, @Nullable MethodParameter parameter) {
        this.pageableResolver = resolver == null ? new HateoasPageableHandlerMethodArgumentResolver() : resolver;
        this.baseUri = baseUri;
        this.parameter = parameter;
    }

    public void setForceFirstRel(boolean forceFirstRel) {
        this.forceFirstRel = forceFirstRel;
    }

    @CheckReturnValue
    public SlicedResourcesAssembler<T> withParameter(@Nullable MethodParameter parameter) {
        return new SlicedResourcesAssembler<T>(this.pageableResolver, this.baseUri, parameter);
    }

    public SlicedModel<EntityModel<T>> toModel(Slice<T> entity) {
        return this.toModel(entity, EntityModel::of);
    }

    public SlicedModel<EntityModel<T>> toModel(Slice<T> slice, Link selfLink) {
        return this.toModel(slice, EntityModel::of, selfLink);
    }

    public <R extends RepresentationModel<?>> SlicedModel<R> toModel(Slice<T> slice, RepresentationModelAssembler<T, R> assembler) {
        return this.createModel(slice, assembler, null);
    }

    public <R extends RepresentationModel<?>> SlicedModel<R> toModel(Slice<T> slice, RepresentationModelAssembler<T, R> assembler, Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null");
        return this.createModel(slice, assembler, link);
    }

    public SlicedModel<?> toEmptyModel(Slice<?> slice, Class<?> type) {
        return this.toEmptyModel(slice, type, (Link)null);
    }

    public SlicedModel<?> toEmptyModel(Slice<?> slice, Class<?> type, @Nullable Link link) {
        Assert.notNull(slice, (String)"Slice must not be null");
        Assert.isTrue((!slice.hasContent() ? 1 : 0) != 0, (String)"Slice must not have any content");
        Assert.notNull(type, (String)"Type must not be null");
        SlicedModel.SliceMetadata metadata = this.asSliceMetadata(slice);
        EmbeddedWrapper wrapper = this.wrappers.emptyCollectionOf(type);
        List<EmbeddedWrapper> embedded = Collections.singletonList(wrapper);
        return this.addPaginationLinks(SlicedModel.of(embedded, (SlicedModel.SliceMetadata)metadata), slice, link);
    }

    @Deprecated
    public SlicedModel<?> toEmptyModel(Slice<?> slice, Class<?> type, Optional<Link> link) {
        return this.toEmptyModel(slice, type, (Link)link.orElse(null));
    }

    protected <R extends RepresentationModel<?>, S> SlicedModel<R> createSlicedModel(List<R> resources, SlicedModel.SliceMetadata metadata, Slice<S> slice) {
        Assert.notNull(resources, (String)"Content resources must not be null");
        Assert.notNull((Object)metadata, (String)"SliceMetadata must not be null");
        Assert.notNull(slice, (String)"Slice must not be null");
        return SlicedModel.of(resources, (SlicedModel.SliceMetadata)metadata);
    }

    private <S, R extends RepresentationModel<?>> SlicedModel<R> createModel(Slice<S> slice, RepresentationModelAssembler<S, R> assembler, @Nullable Link link) {
        Assert.notNull(slice, (String)"Slice must not be null");
        Assert.notNull(assembler, (String)"ResourceAssembler must not be null");
        ArrayList<RepresentationModel> resources = new ArrayList<RepresentationModel>(slice.getNumberOfElements());
        for (Object element : slice) {
            resources.add(assembler.toModel(element));
        }
        SlicedModel resource = this.createSlicedModel(resources, this.asSliceMetadata(slice), slice);
        return this.addPaginationLinks(resource, slice, link);
    }

    private <R> SlicedModel<R> addPaginationLinks(SlicedModel<R> resources, Slice<?> slice, @Nullable Link link) {
        boolean isNavigable;
        UriTemplate base = this.getUriTemplate(link);
        boolean bl = isNavigable = slice.hasPrevious() || slice.hasNext();
        if (isNavigable || this.forceFirstRel) {
            resources.add(this.createLink(base, PageRequest.of(0, slice.getSize(), slice.getSort()), IanaLinkRelations.FIRST));
        }
        Link selfLink = link != null ? link.withSelfRel() : this.createLink(base, slice.getPageable(), IanaLinkRelations.SELF);
        resources.add(selfLink);
        if (slice.hasPrevious()) {
            resources.add(this.createLink(base, slice.previousPageable(), IanaLinkRelations.PREV));
        }
        if (slice.hasNext()) {
            resources.add(this.createLink(base, slice.nextPageable(), IanaLinkRelations.NEXT));
        }
        return resources;
    }

    private UriTemplate getUriTemplate(@Nullable Link baseLink) {
        return UriTemplate.of((String)(baseLink != null ? baseLink.getHref() : this.baseUriOrCurrentRequest()));
    }

    private Link createLink(UriTemplate base, Pageable pageable, LinkRelation relation) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)base.expand(new Object[0]));
        this.pageableResolver.enhance(builder, this.parameter, pageable);
        return Link.of((UriTemplate)UriTemplate.of((String)builder.build().toString()), (LinkRelation)relation);
    }

    private SlicedModel.SliceMetadata asSliceMetadata(Slice<?> slice) {
        Assert.notNull(slice, (String)"Slice must not be null");
        int number = this.pageableResolver.isOneIndexedParameters() ? slice.getNumber() + 1 : slice.getNumber();
        return new SlicedModel.SliceMetadata((long)slice.getSize(), (long)number);
    }

    private String baseUriOrCurrentRequest() {
        return this.baseUri != null ? this.baseUri.toString() : SlicedResourcesAssembler.currentRequest();
    }

    private static String currentRequest() {
        return ServletUriComponentsBuilder.fromCurrentRequest().build().toString();
    }
}

