/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Parameter<T, P extends PersistentProperty<P>> {
    private final @Nullable String name;
    private final TypeInformation<T> type;
    private final MergedAnnotations annotations;
    private final @Nullable String expression;
    private final @Nullable PersistentEntity<T, P> entity;
    private final Lazy<Boolean> enclosingClassCache;
    private final Lazy<Boolean> hasExpression;

    public Parameter(@Nullable String name, TypeInformation<T> type, Annotation[] annotations, @Nullable PersistentEntity<T, P> entity) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.notNull((Object)annotations, (String)"Annotations must not be null");
        this.name = name;
        this.type = type;
        this.annotations = MergedAnnotations.from((Annotation[])annotations);
        this.expression = Parameter.getValue(this.annotations);
        this.entity = entity;
        this.enclosingClassCache = Lazy.of(() -> {
            if (entity == null) {
                throw new IllegalStateException();
            }
            Class owningType = entity.getType();
            return ClassUtils.isInnerClass(owningType) && type.getType().equals(owningType.getEnclosingClass());
        });
        this.hasExpression = Lazy.of(() -> StringUtils.hasText((String)this.getValueExpression()));
    }

    private static @Nullable String getValue(MergedAnnotations annotations) {
        return annotations.get(Value.class).getValue("value", String.class).filter(StringUtils::hasText).orElse(null);
    }

    public @Nullable String getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getRequiredName() {
        if (!this.hasName()) {
            throw new IllegalStateException("No name associated with this parameter");
        }
        return this.getName();
    }

    public TypeInformation<T> getType() {
        return this.type;
    }

    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    public Class<T> getRawType() {
        return this.type.getType();
    }

    public @Nullable String getSpelExpression() {
        return this.getValueExpression();
    }

    public @Nullable String getValueExpression() {
        return this.expression;
    }

    public String getRequiredValueExpression() {
        if (!this.hasValueExpression()) {
            throw new IllegalStateException("No expression associated with this parameter");
        }
        return this.getValueExpression();
    }

    public boolean hasValueExpression() {
        return this.hasExpression.get();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.expression, that.expression) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.expression, this.entity);
    }

    boolean maps(PersistentProperty<?> property) {
        PersistentEntity<T, P> entity = this.entity;
        String name = this.name;
        Object referencedProperty = entity == null ? null : (name == null ? null : entity.getPersistentProperty(name));
        return property.equals(referencedProperty);
    }

    boolean isEnclosingClassParameter() {
        return this.enclosingClassCache.get();
    }
}

