/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.SimplePropertyPath;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public interface PropertyPath
extends Streamable<PropertyPath> {
    public TypeInformation<?> getOwningType();

    public String getSegment();

    default public PropertyPath getLeafProperty() {
        PropertyPath result;
        for (result = this; result != null && result.hasNext(); result = result.next()) {
        }
        return result == null ? this : result;
    }

    default public Class<?> getLeafType() {
        return this.getLeafProperty().getType();
    }

    default public Class<?> getType() {
        return this.getTypeInformation().getRequiredActualType().getType();
    }

    public TypeInformation<?> getTypeInformation();

    public @Nullable PropertyPath next();

    default public boolean hasNext() {
        return this.next() != null;
    }

    default public String toDotPath() {
        PropertyPath next = this.next();
        return next != null ? this.getSegment() + "." + next.toDotPath() : this.getSegment();
    }

    default public boolean isCollection() {
        return this.getTypeInformation().isCollectionLike();
    }

    default public PropertyPath nested(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        String lookup = this.toDotPath().concat(".").concat(path);
        return SimplePropertyPath.from(lookup, this.getOwningType());
    }

    @Override
    public Iterator<PropertyPath> iterator();

    public static PropertyPath from(String source, Class<?> type) {
        return PropertyPath.from(source, TypeInformation.of(type));
    }

    public static PropertyPath from(String source, TypeInformation<?> type) {
        return SimplePropertyPath.from(source, type);
    }
}

