/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.util.Assert;

public final class Similarity
extends Score {
    private Similarity(double value, ScoringFunction function) {
        super(value, function);
    }

    public static Similarity of(double similarity) {
        return Similarity.of(similarity, ScoringFunction.unspecified());
    }

    public static Similarity of(double similarity, ScoringFunction function) {
        Assert.isTrue((similarity >= 0.0 && similarity <= 1.0 ? 1 : 0) != 0, (String)"Similarity must be in [0,1] range.");
        return new Similarity(similarity, function);
    }

    public static Similarity raw(double similarity, ScoringFunction function) {
        return new Similarity(similarity, function);
    }

    public static Range<Similarity> between(Similarity min, Similarity max) {
        return Range.from(Range.Bound.inclusive(min)).to(Range.Bound.inclusive(max));
    }

    public static Range<Similarity> between(double minValue, double maxValue) {
        return Similarity.between(minValue, maxValue, ScoringFunction.unspecified());
    }

    public static Range<Similarity> between(double minValue, double maxValue, ScoringFunction function) {
        return Similarity.between(Similarity.of(minValue, function), Similarity.of(maxValue, function));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Similarity)) {
            return false;
        }
        Similarity other = (Similarity)o;
        return super.equals(other);
    }
}

