/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryInformationSupport;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.Lazy;

class AotRepositoryInformation
extends RepositoryInformationSupport
implements RepositoryInformation {
    private final Supplier<Collection<RepositoryFragment<?>>> fragments;
    private Lazy<RepositoryComposition> baseComposition = Lazy.of(() -> RepositoryComposition.of(RepositoryFragment.structural(this.getRepositoryBaseClass())));

    AotRepositoryInformation(Supplier<RepositoryMetadata> repositoryMetadata, Supplier<Class<?>> repositoryBaseClass, Supplier<Collection<RepositoryFragment<?>>> fragments) {
        super(repositoryMetadata, repositoryBaseClass);
        this.fragments = fragments;
    }

    @Override
    public Set<RepositoryFragment<?>> getFragments() {
        return new LinkedHashSet(this.fragments.get());
    }

    @Override
    public boolean isCustomMethod(Method method) {
        return false;
    }

    @Override
    public boolean isBaseClassMethod(Method method) {
        return this.baseComposition.get().findMethod(method).isPresent();
    }

    @Override
    public Method getTargetClassMethod(Method method) {
        return this.baseComposition.get().findMethod(method).orElse(method);
    }

    @Override
    public RepositoryComposition getRepositoryComposition() {
        return this.baseComposition.get().append(RepositoryComposition.RepositoryFragments.from(this.fragments.get()));
    }
}

