/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.SortDefault;
import org.springframework.data.web.SpringDataAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SortHandlerMethodArgumentResolver
implements SortArgumentResolver {
    private static final String DEFAULT_PARAMETER = "sort";
    private static final String DEFAULT_PROPERTY_DELIMITER = ",";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private static final Sort DEFAULT_SORT = Sort.unsorted();
    private static final String SORT_DEFAULTS_NAME = SortDefault.SortDefaults.class.getSimpleName();
    private static final String SORT_DEFAULT_NAME = SortDefault.class.getSimpleName();
    private Sort fallbackSort = DEFAULT_SORT;
    private String sortParameter = "sort";
    private String propertyDelimiter = ",";
    private String qualifierDelimiter = "_";

    public void setSortParameter(String sortParameter) {
        Assert.hasText((String)sortParameter, (String)"SortParameter must not be null nor empty!");
        this.sortParameter = sortParameter;
    }

    public void setPropertyDelimiter(String propertyDelimiter) {
        Assert.hasText((String)propertyDelimiter, (String)"Property delimiter must not be null or empty!");
        this.propertyDelimiter = propertyDelimiter;
    }

    public void setQualifierDelimiter(String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Sort.class.equals((Object)parameter.getParameterType());
    }

    @Override
    public Sort resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        String[] directionParameter = webRequest.getParameterValues(this.getSortParameter(parameter));
        if (directionParameter == null) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        if (directionParameter.length == 1 && !StringUtils.hasText((String)directionParameter[0])) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        return this.parseParameterIntoSort(directionParameter, this.propertyDelimiter);
    }

    private Sort getDefaultFromAnnotationOrFallback(MethodParameter parameter) {
        SortDefault.SortDefaults annotatedDefaults = (SortDefault.SortDefaults)parameter.getParameterAnnotation(SortDefault.SortDefaults.class);
        SortDefault annotatedDefault = (SortDefault)parameter.getParameterAnnotation(SortDefault.class);
        if (annotatedDefault != null && annotatedDefaults != null) {
            throw new IllegalArgumentException(String.format("Cannot use both @%s and @%s on parameter %s! Move %s into %s to define sorting order!", SORT_DEFAULTS_NAME, SORT_DEFAULT_NAME, parameter.toString(), SORT_DEFAULT_NAME, SORT_DEFAULTS_NAME));
        }
        if (annotatedDefault != null) {
            return this.appendOrCreateSortTo(annotatedDefault, Sort.unsorted());
        }
        if (annotatedDefaults != null) {
            Sort sort = Sort.unsorted();
            for (SortDefault currentAnnotatedDefault : annotatedDefaults.value()) {
                sort = this.appendOrCreateSortTo(currentAnnotatedDefault, sort);
            }
            return sort;
        }
        return this.fallbackSort;
    }

    private Sort appendOrCreateSortTo(SortDefault sortDefault, Sort sortOrNull) {
        String[] fields = (String[])SpringDataAnnotationUtils.getSpecificPropertyOrDefaultFromValue(sortDefault, DEFAULT_PARAMETER);
        if (fields.length == 0) {
            return Sort.unsorted();
        }
        return sortOrNull.and(Sort.by(sortDefault.direction(), fields));
    }

    protected String getSortParameter(@Nullable MethodParameter parameter) {
        Qualifier qualifier;
        StringBuilder builder = new StringBuilder();
        Qualifier qualifier2 = qualifier = parameter != null ? (Qualifier)parameter.getParameterAnnotation(Qualifier.class) : null;
        if (qualifier != null) {
            builder.append(qualifier.value()).append(this.qualifierDelimiter);
        }
        return builder.append(this.sortParameter).toString();
    }

    Sort parseParameterIntoSort(String[] source, String delimiter) {
        ArrayList<Sort.Order> allOrders = new ArrayList<Sort.Order>();
        for (String part : source) {
            if (part == null) continue;
            String[] elements = part.split(delimiter);
            Optional<Sort.Direction> direction = elements.length == 0 ? Optional.empty() : Sort.Direction.fromOptionalString(elements[elements.length - 1]);
            int lastIndex = direction.map(it -> elements.length - 1).orElseGet(() -> elements.length);
            for (int i = 0; i < lastIndex; ++i) {
                SortHandlerMethodArgumentResolver.toOrder(elements[i], direction).ifPresent(allOrders::add);
            }
        }
        return allOrders.isEmpty() ? Sort.unsorted() : Sort.by(allOrders);
    }

    private static Optional<Sort.Order> toOrder(String property, Optional<Sort.Direction> direction) {
        if (!StringUtils.hasText((String)property)) {
            return Optional.empty();
        }
        return Optional.of(direction.map(it -> new Sort.Order((Sort.Direction)((Object)it), property)).orElseGet(() -> Sort.Order.by(property)));
    }

    protected List<String> foldIntoExpressions(Sort sort) {
        ArrayList<String> expressions = new ArrayList<String>();
        ExpressionBuilder builder = null;
        for (Sort.Order order : sort) {
            Sort.Direction direction = order.getDirection();
            if (builder == null) {
                builder = new ExpressionBuilder(direction);
            } else if (!builder.hasSameDirectionAs(order)) {
                builder.dumpExpressionIfPresentInto(expressions);
                builder = new ExpressionBuilder(direction);
            }
            builder.add(order.getProperty());
        }
        return builder == null ? Collections.emptyList() : builder.dumpExpressionIfPresentInto(expressions);
    }

    protected List<String> legacyFoldExpressions(Sort sort) {
        ArrayList<String> expressions = new ArrayList<String>();
        ExpressionBuilder builder = null;
        for (Sort.Order order : sort) {
            Sort.Direction direction = order.getDirection();
            if (builder == null) {
                builder = new ExpressionBuilder(direction);
            } else if (!builder.hasSameDirectionAs(order)) {
                throw new IllegalArgumentException(String.format("%s in legacy configuration only supports a single direction to sort by!", this.getClass().getSimpleName()));
            }
            builder.add(order.getProperty());
        }
        return builder == null ? Collections.emptyList() : builder.dumpExpressionIfPresentInto(expressions);
    }

    public void setFallbackSort(Sort fallbackSort) {
        this.fallbackSort = fallbackSort;
    }

    class ExpressionBuilder {
        private final List<String> elements = new ArrayList<String>();
        private final Sort.Direction direction;

        public ExpressionBuilder(Sort.Direction direction) {
            Assert.notNull((Object)((Object)direction), (String)"Direction must not be null!");
            this.direction = direction;
        }

        public boolean hasSameDirectionAs(Sort.Order order) {
            return this.direction == order.getDirection();
        }

        public void add(String property) {
            this.elements.add(property);
        }

        public List<String> dumpExpressionIfPresentInto(List<String> expressions) {
            if (this.elements.isEmpty()) {
                return expressions;
            }
            this.elements.add(this.direction.name().toLowerCase());
            expressions.add(StringUtils.collectionToDelimitedString(this.elements, (String)SortHandlerMethodArgumentResolver.this.propertyDelimiter));
            return expressions;
        }
    }
}

