/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataWebConfiguration;
import org.springframework.util.ClassUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Inherited
@Import(value={SpringDataWebConfigurationImportSelector.class})
public @interface EnableSpringDataWebSupport {

    public static class SpringDataWebConfigurationImportSelector
    implements ImportSelector {
        private static boolean HATEOAS_PRESENT = ClassUtils.isPresent((String)"org.springframework.hateoas.Link", null);

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{HATEOAS_PRESENT ? HateoasAwareSpringDataWebConfiguration.class.getName() : SpringDataWebConfiguration.class.getName()};
        }
    }
}

